/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Function2;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.config.ReindexMessage;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.IndexingConfiguration;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.event.listeners.search.IssueIndexListener;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.IssueIndexHelper;
import com.atlassian.jira.index.ha.ReplicatedIndexManager;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.BackgroundIndexListener;
import com.atlassian.jira.issue.index.IndexConsistencyUtils;
import com.atlassian.jira.issue.index.IndexDeactivatedEvent;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IndexReconciler;
import com.atlassian.jira.issue.index.IndexingShutdownEvent;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueSearcherFactory;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.index.JiraAnalyzer;
import com.atlassian.jira.issue.index.ReindexAllCancelledEvent;
import com.atlassian.jira.issue.index.ReindexAllCompletedEvent;
import com.atlassian.jira.issue.index.ReindexAllStartedEvent;
import com.atlassian.jira.issue.index.ReindexIssuesCompletedEvent;
import com.atlassian.jira.issue.index.ReindexIssuesStartedEvent;
import com.atlassian.jira.issue.index.SearchUnavailableException;
import com.atlassian.jira.issue.index.SearcherCache;
import com.atlassian.jira.issue.util.DatabaseIssuesIterable;
import com.atlassian.jira.issue.util.IssueGVsIssueIterable;
import com.atlassian.jira.issue.util.IssueObjectIssuesIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.IndexSearcher;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexManager
implements IssueIndexManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexManager.class);
    public static final Analyzer ANALYZER_FOR_SEARCHING = JiraAnalyzer.ANALYZER_FOR_SEARCHING;
    public static final Analyzer ANALYZER_FOR_INDEXING = JiraAnalyzer.ANALYZER_FOR_INDEXING;
    @ClusterSafe(value="Indexes are local to each node")
    private final IndexLocks indexLock = new IndexLocks();
    private final IssueIndexer issueIndexer;
    private final IndexPathManager indexPathManager;
    private final IndexingConfiguration indexConfig;
    private final ReindexMessageManager reindexMessageManager;
    private final EventPublisher eventPublisher;
    private final ListenerManager listenerManager;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final TaskManager taskManager;
    private final OfBizDelegator ofBizDelegator;
    private final IssueSearcherFactory issueSearcherFactory;
    private final ReplicatedIndexManager replicatedIndexManager;
    private final TimeTrackingConfiguration timeTrackingConfiguration;
    private final ThreadLocal<Boolean> indexingHeld = new ThreadLocal();
    private final ThreadLocal<Map<String, Issue>> heldIssues = new ThreadLocal<Map<String, Issue>>(){

        @Override
        protected Map<String, Issue> initialValue() {
            return new HashMap<String, Issue>();
        }
    };

    public Analyzer getAnalyzerForSearching() {
        return ANALYZER_FOR_SEARCHING;
    }

    public Analyzer getAnalyzerForIndexing() {
        return ANALYZER_FOR_INDEXING;
    }

    public DefaultIndexManager(IndexingConfiguration indexProperties, IssueIndexer issueIndexer, IndexPathManager indexPath, ReindexMessageManager reindexMessageManager, EventPublisher eventPublisher, ListenerManager listenerManager, ProjectManager projectManager, IssueManager issueManager, TaskManager taskManager, OfBizDelegator ofBizDelegator, ReplicatedIndexManager replicatedIndexManager, IssueSearcherFactory issueSearcherFactory, TimeTrackingConfiguration timeTrackingConfiguration) {
        this.issueManager = issueManager;
        this.taskManager = taskManager;
        this.ofBizDelegator = ofBizDelegator;
        this.issueSearcherFactory = issueSearcherFactory;
        this.timeTrackingConfiguration = timeTrackingConfiguration;
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
        this.indexConfig = (IndexingConfiguration)Assertions.notNull((String)"indexProperties", (Object)indexProperties);
        this.issueIndexer = (IssueIndexer)Assertions.notNull((String)"issueIndexer", (Object)issueIndexer);
        this.indexPathManager = (IndexPathManager)Assertions.notNull((String)"indexPath", (Object)indexPath);
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
        this.listenerManager = listenerManager;
        this.projectManager = projectManager;
        this.replicatedIndexManager = replicatedIndexManager;
    }

    public void deactivate() {
        this.listenerManager.deleteListener(IssueIndexListener.class);
        this.indexConfig.disableIndex();
        this.issueIndexer.shutdown();
        DefaultIndexManager.flushThreadLocalSearchers();
        this.eventPublisher.publish((Object)new IndexDeactivatedEvent());
    }

    public long activate(Context context) {
        return this.activate(context, true);
    }

    public long activate(Context context, boolean reindex) {
        Assertions.notNull((String)"context", (Object)context);
        if (this.isIndexAvailable()) {
            throw new IllegalStateException("Cannot enable indexing as it is already enabled.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Activating indexes in '" + this.indexPathManager.getIndexRootPath() + "'.");
        }
        this.listenerManager.createListener("Issue Index Listener", IssueIndexListener.class);
        this.indexConfig.enableIndex();
        if (reindex) {
            return this.reIndexAll(context);
        }
        return 0L;
    }

    public boolean isIndexingEnabled() {
        return this.indexConfig.isIndexAvailable();
    }

    public boolean isIndexAvailable() {
        return this.indexConfig.isIndexAvailable();
    }

    public long reIndexAll() throws IndexException {
        return this.reIndexAll(Contexts.nullContext());
    }

    public long reIndexAll(Context context) {
        return this.reIndexAll(context, false);
    }

    public long reIndexAll(Context context, boolean useBackgroundIndexing) {
        return this.reIndexAll(context, useBackgroundIndexing, true);
    }

    public long reIndexAll(Context context, boolean useBackgroundIndexing, boolean updateReplicatedIndex) {
        IssueIndexingParams indexingParams = useBackgroundIndexing ? IssueIndexingParams.INDEX_ISSUE_ONLY : IssueIndexingParams.INDEX_ALL;
        return this.reIndexAll(context, useBackgroundIndexing, indexingParams, updateReplicatedIndex);
    }

    public long reIndexAll(Context context, boolean useBackgroundIndexing, boolean reIndexComments, boolean reIndexChangeHistory, boolean updateReplicatedIndex) {
        IssueIndexingParams indexingInBackgroundParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        IssueIndexingParams issueIndexingParams = useBackgroundIndexing ? indexingInBackgroundParams : IssueIndexingParams.INDEX_ALL;
        return this.reIndexAll(context, useBackgroundIndexing, issueIndexingParams, updateReplicatedIndex);
    }

    public long reIndexAll(Context context, IssueIndexingParams issueIndexingParams) {
        return this.reIndexAll(context, false, issueIndexingParams, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reIndexAll(final Context context, boolean useBackgroundIndexing, final IssueIndexingParams issueIndexingParams, boolean updateReplicatedIndex) {
        Assertions.notNull((String)"context", (Object)context);
        context.setName("Issue");
        IssueIndexingParams filteredIssueIndexingParams = this.filterIndexingParams(issueIndexingParams);
        if (!filteredIssueIndexingParams.isIndex()) {
            return -1L;
        }
        log.info("Reindexing: " + filteredIssueIndexingParams);
        long startTime = System.currentTimeMillis();
        ReindexMessage message = this.reindexMessageManager.getMessageObject();
        this.eventPublisher.publish((Object)new ReindexAllStartedEvent(useBackgroundIndexing, updateReplicatedIndex, filteredIssueIndexingParams, message == null ? null : message));
        if (useBackgroundIndexing) {
            if (!this.getIndexLock()) {
                log.error("Could not perform background re-index");
                return -1L;
            }
            try {
                this.doBackgroundReindex(context, filteredIssueIndexingParams);
            }
            catch (InterruptedException e) {
                this.eventPublisher.publish((Object)new ReindexAllCancelledEvent());
                long l = -1L;
                return l;
            }
            finally {
                this.releaseIndexLock();
                DefaultIndexManager.flushThreadLocalSearchers();
            }
        } else if (!this.withReindexLock(new Runnable(){

            @Override
            public void run() {
                DefaultIndexManager.this.doStopTheWorldReindex(context, issueIndexingParams);
            }
        })) {
            return -1L;
        }
        if (message != null) {
            this.reindexMessageManager.clearMessageForTimestamp(message.getTime());
        }
        long duration = System.currentTimeMillis() - startTime;
        if (log.isDebugEnabled()) {
            log.debug("ReindexAll took : " + duration + "ms");
        }
        this.eventPublisher.publish((Object)new ReindexAllCompletedEvent(startTime, duration, useBackgroundIndexing, updateReplicatedIndex, filteredIssueIndexingParams, Long.valueOf(this.issueManager.getIssueCount())));
        return duration;
    }

    public boolean withReindexLock(Runnable runnable) {
        if (!this.indexLock.writeLock.tryLock()) {
            return false;
        }
        try {
            runnable.run();
        }
        finally {
            this.indexLock.writeLock.unlock();
            DefaultIndexManager.flushThreadLocalSearchers();
        }
        return true;
    }

    public long reIndexAllIssuesInBackground(Context context) {
        return this.reIndexAll(context, true, IssueIndexingParams.INDEX_ISSUE_ONLY, true);
    }

    public long reIndexAllIssuesInBackground(Context context, boolean reIndexComments, boolean reIndexChangeHistory) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        return this.reIndexAll(context, true, issueIndexingParams, true);
    }

    public long reIndexIssuesInBackground(Context context, IssueIndexingParams issueIndexingParams) {
        return this.reIndexAll(context, true, issueIndexingParams, true);
    }

    public long reIndexIssues(Collection<GenericValue> issues) throws IndexException {
        return this.reIndexIssues(new IssueGVsIssueIterable(issues, this.getIssueFactory()), Contexts.nullContext());
    }

    protected long reIndexIssues(Collection<GenericValue> issues, IssueIndexingParams issueIndexingParams) throws IndexException {
        return this.reIndexIssues(new IssueGVsIssueIterable(issues, this.getIssueFactory()), Contexts.nullContext(), issueIndexingParams);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects) throws IndexException {
        return this.reIndexIssueObjects(issueObjects, IssueIndexingParams.INDEX_ALL);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects, boolean reIndexComments, boolean reIndexChangeHistory) throws IndexException {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        return this.reIndexIssueObjects(issueObjects, issueIndexingParams);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects, IssueIndexingParams issueIndexingParams) throws IndexException {
        Collection genericValues = CollectionUtils.collect(issueObjects, (Transformer)IssueFactory.TO_GENERIC_VALUE);
        return this.reIndexIssues(genericValues, issueIndexingParams);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects, boolean reIndexComments, boolean reIndexChangeHistory, boolean updateReplicatedIndexStore) throws IndexException {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        return this.reIndexIssueObjects(issueObjects, issueIndexingParams, updateReplicatedIndexStore);
    }

    public long reIndexIssueObjects(Collection<? extends Issue> issueObjects, IssueIndexingParams issueIndexingParams, boolean updateReplicatedIndexStore) throws IndexException {
        return this.reIndexIssues((IssuesIterable)new IssueObjectIssuesIterable(issueObjects), Contexts.nullContext(), issueIndexingParams, updateReplicatedIndexStore);
    }

    public void reIndex(Issue issue) throws IndexException {
        this.reIndex(issue, IssueIndexingParams.INDEX_ALL);
    }

    public void reIndex(Issue issue, boolean reIndexComments, boolean reIndexChangeHistory) throws IndexException {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        this.reIndex(issue, issueIndexingParams);
    }

    public void reIndex(Issue issue, IssueIndexingParams issueIndexingParams) throws IndexException {
        List<Issue> issues = Collections.singletonList(issue);
        this.reIndexIssueObjects(issues, issueIndexingParams, true);
    }

    public void reIndex(GenericValue issueGV) throws IndexException {
        if ("Issue".equals(issueGV.getEntityName())) {
            ArrayList genericValues = Lists.newArrayList((Object[])new GenericValue[]{issueGV});
            this.reIndexIssues(genericValues);
        } else {
            log.error("Entity is not an issue " + issueGV.getEntityName());
        }
    }

    public void hold() {
        this.indexingHeld.set(Boolean.TRUE);
    }

    public boolean isHeld() {
        return this.indexingHeld.get() != null && this.indexingHeld.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long release() throws IndexException {
        this.indexingHeld.set(Boolean.FALSE);
        try {
            Map<String, Issue> queue = this.heldIssues.get();
            if (queue.size() > 0) {
                IssueObjectIssuesIterable issuesIterable = new IssueObjectIssuesIterable(queue.values());
                long l = this.reIndexIssues(issuesIterable, Contexts.nullContext());
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.heldIssues.remove();
            this.indexingHeld.remove();
        }
    }

    public long reIndexIssues(IssuesIterable issuesIterable, Context context) throws IndexException {
        return this.reIndexIssues(issuesIterable, context, IssueIndexingParams.INDEX_ALL);
    }

    public long reIndexIssues(IssuesIterable issuesIterable, Context context, boolean reIndexComments, boolean reIndexChangeHistory) throws IndexException {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        return this.reIndexIssues(issuesIterable, context, issueIndexingParams);
    }

    public long reIndexIssues(IssuesIterable issuesIterable, Context context, IssueIndexingParams issueIndexingParams) throws IndexException {
        return this.reIndexIssues(issuesIterable, context, issueIndexingParams, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long reIndexIssues(IssuesIterable issuesIterable, Context context, IssueIndexingParams issueIndexingParams, boolean updateReplicatedIndexStore) {
        if (this.isHeld()) {
            final Map<String, Issue> queue = this.heldIssues.get();
            issuesIterable.foreach((Consumer)new Consumer<Issue>(){

                public void consume(@Nonnull Issue element) {
                    queue.put(element.getKey(), element);
                }
            });
            return 0L;
        }
        Assertions.notNull((String)"issues", (Object)issuesIterable);
        Assertions.notNull((String)"context", (Object)context);
        this.eventPublisher.publish((Object)new ReindexIssuesStartedEvent());
        OpTimer opTimer = Instrumentation.pullTimer(InstrumentationName.ISSUE_INDEX_WRITES);
        if (!this.getIndexLock()) {
            log.error("Could not reindex: " + issuesIterable.toString());
            return -1L;
        }
        try {
            this.await(this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)issuesIterable, context, issueIndexingParams, false));
        }
        finally {
            this.releaseIndexLock();
            DefaultIndexManager.flushThreadLocalSearchers();
            if (updateReplicatedIndexStore) {
                this.replicatedIndexManager.reindexIssues(issuesIterable);
            }
            opTimer.end();
        }
        long totalTime = opTimer.snapshot().getMillisecondsTaken();
        if (log.isDebugEnabled()) {
            log.debug("Reindexed " + issuesIterable.size() + " issues in " + totalTime + "ms.");
        }
        this.eventPublisher.publish((Object)new ReindexIssuesCompletedEvent(totalTime));
        return totalTime;
    }

    public long reIndexComments(Collection<Comment> comments) throws IndexException {
        return this.reIndexComments(comments, Contexts.nullContext());
    }

    public long reIndexComments(Collection<Comment> comments, Context context) throws IndexException {
        return this.reIndexComments(comments, context, true);
    }

    public long reIndexComments(Collection<Comment> comments, Context context, boolean updateReplicatedIndexStore) throws IndexException {
        Function2<Collection<Comment>, Context, Index.Result> reindexFunction = new Function2<Collection<Comment>, Context, Index.Result>(){

            public Index.Result apply(Collection<Comment> comments, Context context) {
                return DefaultIndexManager.this.issueIndexer.reindexComments(comments, context);
            }
        };
        return this.reIndexRelatedEntity(comments, context, updateReplicatedIndexStore, AffectedIndex.COMMENT, reindexFunction);
    }

    private int getCommentCount() {
        EntityFieldMap condition = new EntityFieldMap((Map)FieldMap.build((String)"type", (Object)"comment"), EntityOperator.AND);
        List commentCount = this.ofBizDelegator.findByCondition("ActionCount", (EntityCondition)condition, (Collection)ImmutableList.of((Object)"count"));
        if (commentCount != null && commentCount.size() == 1) {
            GenericValue commentCountGV = (GenericValue)commentCount.get(0);
            return commentCountGV.getLong("count").intValue();
        }
        throw new DataAccessException("Unable to access the count for the Action table");
    }

    public long reIndexWorklogs(Collection<Worklog> worklogs) throws IndexException {
        return this.reIndexWorklogs(worklogs, Contexts.nullContext());
    }

    public long reIndexWorklogs(Collection<Worklog> worklogs, Context context) throws IndexException {
        return this.reIndexWorklogs(worklogs, context, true);
    }

    public long reIndexWorklogs(Collection<Worklog> worklogs, Context context, boolean updateReplicatedIndexStore) throws IndexException {
        Function2<Collection<Worklog>, Context, Index.Result> reindexFunction = new Function2<Collection<Worklog>, Context, Index.Result>(){

            public Index.Result apply(Collection<Worklog> worklogs, Context context) {
                return DefaultIndexManager.this.issueIndexer.reindexWorklogs(worklogs, context);
            }
        };
        return this.reIndexRelatedEntity(worklogs, context, updateReplicatedIndexStore, AffectedIndex.WORKLOG, reindexFunction);
    }

    private int getWorklogCount() {
        return (int)this.ofBizDelegator.getCount("Worklog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends WithId> long reIndexRelatedEntity(Collection<T> entities, Context context, boolean updateReplicatedIndexStore, AffectedIndex affectedIndex, Function2<Collection<T>, Context, Index.Result> reindexFunction) throws IndexException {
        Assertions.notNull((String)"entities", entities);
        Assertions.notNull((String)"context", (Object)context);
        this.eventPublisher.publish((Object)new ReindexIssuesStartedEvent());
        OpTimer opTimer = Instrumentation.pullTimer(InstrumentationName.ISSUE_INDEX_WRITES);
        if (!this.getIndexLock()) {
            log.error("Could not reindex: " + entities.toString());
            return -1L;
        }
        try {
            this.await((Index.Result)reindexFunction.apply(entities, (Object)context));
        }
        finally {
            this.releaseIndexLock();
            DefaultIndexManager.flushThreadLocalSearchers();
            if (updateReplicatedIndexStore) {
                this.replicatedIndexManager.reindexEntity(entities, affectedIndex);
            }
            opTimer.end();
        }
        long totalTime = opTimer.snapshot().getMillisecondsTaken();
        if (log.isDebugEnabled()) {
            log.debug("Reindexed " + entities.size() + " entities in " + totalTime + "ms.");
        }
        this.eventPublisher.publish((Object)new ReindexIssuesCompletedEvent(totalTime));
        return totalTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexConsistent() {
        IndexSearcher issueSearcher = null;
        IndexSearcher commentSearcher = null;
        IndexSearcher changeHistorySearcher = null;
        IndexSearcher workLogSearcher = null;
        try {
            issueSearcher = this.issueIndexer.openEntitySearcher(IndexDirectoryFactory.Name.ISSUE);
            commentSearcher = this.issueIndexer.openEntitySearcher(IndexDirectoryFactory.Name.COMMENT);
            changeHistorySearcher = this.issueIndexer.openEntitySearcher(IndexDirectoryFactory.Name.CHANGE_HISTORY);
            workLogSearcher = this.issueIndexer.openEntitySearcher(IndexDirectoryFactory.Name.WORKLOG);
            boolean bl = IndexConsistencyUtils.isIndexConsistent("Issue", this.size(), issueSearcher) && IndexConsistencyUtils.isIndexConsistent("Comment", this.getCommentCount(), commentSearcher) && IndexConsistencyUtils.isIndexConsistent("ChangeHistory", -1, changeHistorySearcher) && IndexConsistencyUtils.isIndexConsistent("Worklog", this.getWorklogCount(), workLogSearcher);
            this.closeQuietly(issueSearcher);
            this.closeQuietly(commentSearcher);
            this.closeQuietly(changeHistorySearcher);
            this.closeQuietly(workLogSearcher);
            return bl;
        }
        catch (Exception ex) {
            try {
                log.warn("Exception during index consistency check: " + ex);
                boolean bl = false;
                this.closeQuietly(issueSearcher);
                this.closeQuietly(commentSearcher);
                this.closeQuietly(changeHistorySearcher);
                this.closeQuietly(workLogSearcher);
                return bl;
            }
            catch (Throwable throwable) {
                this.closeQuietly(issueSearcher);
                this.closeQuietly(commentSearcher);
                this.closeQuietly(changeHistorySearcher);
                this.closeQuietly(workLogSearcher);
                throw throwable;
            }
        }
    }

    public void closeQuietly(IndexSearcher issueSearcher) {
        if (issueSearcher != null) {
            try {
                issueSearcher.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int size() {
        return new DatabaseIssuesIterable(this.ofBizDelegator, this.getIssueFactory()).size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public long optimize() {
        if (!this.isIndexAvailable()) {
            return 0L;
        }
        if (!this.getIndexLock()) {
            return -1L;
        }
        try {
            long l = this.optimize0();
            return l;
        }
        finally {
            this.releaseIndexLock();
        }
    }

    @GuardedBy(value="index read lock")
    private long optimize0() {
        long startTime = System.currentTimeMillis();
        this.issueIndexer.optimize().await();
        return System.currentTimeMillis() - startTime;
    }

    public void deIndex(Issue issue) throws IndexException {
        this.deIndexIssueObjects(Sets.newHashSet((Object[])new Issue[]{issue}), true);
    }

    public void deIndexIssueObjects(Set<Issue> issuesToDelete, boolean updateReplicatedIndexStore) throws IndexException {
        if (issuesToDelete == null || issuesToDelete.isEmpty()) {
            return;
        }
        if (!this.getIndexLock()) {
            log.error("Could not deindex: " + issuesToDelete.iterator().next().getKey());
            return;
        }
        try {
            this.await(this.issueIndexer.deindexIssues((EnclosedIterable<Issue>)new IssueObjectIssuesIterable(issuesToDelete), Contexts.nullContext()));
        }
        finally {
            this.releaseIndexLock();
            DefaultIndexManager.flushThreadLocalSearchers();
            if (updateReplicatedIndexStore) {
                this.replicatedIndexManager.deIndexIssues(issuesToDelete);
            }
        }
    }

    public void deIndex(GenericValue entity) throws IndexException {
        if (!"Issue".equals(entity.getEntityName())) {
            log.error("Entity is not an issue " + entity.getEntityName());
            return;
        }
        this.deIndex((Issue)this.getIssueFactory().getIssue(entity));
    }

    private void await(final Index.Result result) {
        this.obtain(new Awaitable(){

            @Override
            public boolean await(long time, TimeUnit unit) throws InterruptedException {
                return result.await(time, unit);
            }
        });
    }

    @VisibleForTesting
    void releaseIndexLock() {
        this.indexLock.readLock.unlock();
    }

    @VisibleForTesting
    boolean getIndexLock() {
        if (StringUtils.isBlank((String)this.indexPathManager.getIndexRootPath())) {
            log.error("File path not set - not indexing");
            return false;
        }
        return this.indexLock.readLock.tryLock();
    }

    private boolean obtain(Awaitable waitFor) {
        try {
            if (waitFor.await(this.indexConfig.getIndexLockWaitTime(), TimeUnit.MILLISECONDS)) {
                return true;
            }
        }
        catch (InterruptedException ie) {
            log.error("Wait attempt interrupted.", (Throwable)new IndexException("Wait attempt interrupted.", (Exception)ie));
            return false;
        }
        String errorMessage = "Wait attempt timed out - waited " + this.indexConfig.getIndexLockWaitTime() + " milliseconds";
        log.error(errorMessage, (Throwable)new IndexException(errorMessage));
        return false;
    }

    public String getPluginsRootPath() {
        return this.indexPathManager.getPluginIndexRootPath();
    }

    public List<String> getExistingPluginsPaths() {
        String[] listing;
        File pluginRootPath = new File(this.getPluginsRootPath());
        if (pluginRootPath.exists() && pluginRootPath.isDirectory() && pluginRootPath.canRead() && (listing = pluginRootPath.list()) != null) {
            ArrayList<String> subdirs = new ArrayList<String>(listing.length);
            for (String element : listing) {
                File f = new File(pluginRootPath, element);
                if (!f.exists() || !f.canRead() || !f.isDirectory()) continue;
                subdirs.add(f.getAbsolutePath());
            }
            return Collections.unmodifiableList(subdirs);
        }
        return Collections.emptyList();
    }

    public IndexSearcher getIssueSearcher() {
        return this.getEntitySearcher(IndexDirectoryFactory.Name.ISSUE);
    }

    public IndexSearcher getCommentSearcher() {
        return this.getEntitySearcher(IndexDirectoryFactory.Name.COMMENT);
    }

    public IndexSearcher getChangeHistorySearcher() {
        return this.getEntitySearcher(IndexDirectoryFactory.Name.CHANGE_HISTORY);
    }

    public IndexSearcher getWorklogSearcher() {
        return this.getEntitySearcher(IndexDirectoryFactory.Name.WORKLOG);
    }

    private IndexSearcher getEntitySearcher(IndexDirectoryFactory.Name index) {
        if (!this.getIndexLock()) {
            throw new SearchUnavailableException(null, this.indexConfig.isIndexAvailable());
        }
        try {
            IndexSearcher indexSearcher = this.issueSearcherFactory.getEntitySearcher(index);
            return indexSearcher;
        }
        finally {
            this.releaseIndexLock();
        }
    }

    public Collection<String> getAllIndexPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(this.issueIndexer.getIndexPaths());
        paths.addAll(this.getExistingPluginsPaths());
        return Collections.unmodifiableList(paths);
    }

    public void shutdown() {
        this.eventPublisher.publish((Object)new IndexingShutdownEvent());
        DefaultIndexManager.flushThreadLocalSearchers();
        this.issueIndexer.shutdown();
    }

    IssueFactory getIssueFactory() {
        return (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
    }

    IssueBatcherFactory getIssueBatcherFactory() {
        return (IssueBatcherFactory)ComponentAccessor.getComponent(IssueBatcherFactory.class);
    }

    public String toString() {
        return "DefaultIndexManager: paths: " + this.getAllIndexPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBackgroundReindex(Context context, IssueIndexingParams issueIndexingParams) throws InterruptedException {
        StopWatch watch = new StopWatch();
        watch.start();
        IssueIndexHelper issueIndexHelper = new IssueIndexHelper(this.issueManager, this.issueIndexer, this.getIssueFactory());
        long[] indexedIssues = issueIndexHelper.getAllIssueIds();
        IndexReconciler reconciler = new IndexReconciler(indexedIssues);
        AccumulatingResultBuilder resultBuilder = new AccumulatingResultBuilder();
        log.info("Reindexing " + indexedIssues.length + " issues in the background.");
        TaskDescriptor currentTaskDescriptor = this.taskManager.getLiveTask(new IndexTaskContext());
        BackgroundIndexListener backgroundIndexListener = new BackgroundIndexListener();
        this.eventPublisher.register((Object)backgroundIndexListener);
        try {
            IssuesBatcher batcher = this.getIssueBatcherFactory().getBatcher(reconciler);
            for (IssuesIterable batchOfIssues : batcher) {
                TaskDescriptor taskDescriptor = this.taskManager.getTask(currentTaskDescriptor.getTaskId());
                if (taskDescriptor != null && taskDescriptor.isCancelled()) break;
                resultBuilder.add(this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batchOfIssues, context, issueIndexingParams, false));
            }
            resultBuilder.toResult().await();
        }
        finally {
            this.eventPublisher.unregister((Object)backgroundIndexListener);
            log.info(indexedIssues.length + " issues reindexed in the background, in " + watch.getTime() + " millis.");
            watch.split();
            issueIndexHelper.fixupConcurrentlyIndexedIssues(context, resultBuilder, backgroundIndexListener, issueIndexingParams);
            log.info("" + backgroundIndexListener.getTotalModifications() + " concurrently modified issues reindexed in " + (watch.getTime() - watch.getSplitTime()) + " millis.");
            watch.split();
        }
        TaskDescriptor taskDescriptor = this.taskManager.getTask(currentTaskDescriptor.getTaskId());
        if (taskDescriptor != null && taskDescriptor.isCancelled()) {
            log.info("Background reindex cancelled.");
            throw new InterruptedException();
        }
        issueIndexHelper.fixupIndexCorruptions(resultBuilder, reconciler);
        log.info("Reindexing " + this.issueSearcherFactory.getEntitySearcher(IndexDirectoryFactory.Name.ISSUE).getIndexReader().numDocs() + " issues in the background completed in " + watch.getTime() + " millis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStopTheWorldReindex(Context context, IssueIndexingParams issueIndexingParams) {
        LifecycleAwareSchedulerService schedulerService = (LifecycleAwareSchedulerService)ComponentAccessor.getComponent(LifecycleAwareSchedulerService.class);
        boolean restartScheduler = false;
        try {
            try {
                if (schedulerService.getState() == LifecycleAwareSchedulerService.State.STARTED) {
                    schedulerService.standby();
                    restartScheduler = true;
                }
            }
            catch (SchedulerServiceException e) {
                log.warn("Unable to place the scheduler service in standby mode during reindex", (Throwable)e);
            }
            this.issueIndexer.deleteIndexes(issueIndexingParams);
            this.doIndexIssuesInBatchMode(context, issueIndexingParams);
            this.optimize0();
        }
        finally {
            if (restartScheduler) {
                try {
                    schedulerService.start();
                }
                catch (SchedulerServiceException e) {
                    log.error("Unable to restart the scheduler after reindex", (Throwable)e);
                }
            }
        }
    }

    private void doIndexIssuesInBatchMode(Context context, IssueIndexingParams issueIndexingParams) {
        AccumulatingResultBuilder resultBuilder = new AccumulatingResultBuilder();
        IssuesBatcher batcher = this.getIssueBatcherFactory().getBatcher();
        for (IssuesIterable batchOfIssues : batcher) {
            resultBuilder.add(this.issueIndexer.indexIssuesBatchMode((EnclosedIterable<Issue>)batchOfIssues, context, issueIndexingParams));
        }
        resultBuilder.toResult().await();
    }

    public static void flushThreadLocalSearchers() {
        SearcherCache.getThreadLocalCache().closeSearchers();
    }

    private IssueIndexingParams filterIndexingParams(IssueIndexingParams issueIndexingParams) {
        return IssueIndexingParams.builder().withoutIssues().addIndexingParams(issueIndexingParams).setComments(issueIndexingParams.isIndexComments() && this.shouldCommentsBeReindexed()).setWorklogs(issueIndexingParams.isIndexWorklogs() && this.shouldWorklogsBeReindexed()).build();
    }

    private boolean shouldCommentsBeReindexed() {
        return this.getCommentCount() > 0;
    }

    private boolean shouldWorklogsBeReindexed() {
        return this.timeTrackingConfiguration.enabled() && this.getWorklogCount() > 0;
    }

    private final class IndexLock {
        private final Lock lock;

        private IndexLock(Lock lock) {
            this.lock = (Lock)Assertions.notNull((String)"lock", (Object)lock);
        }

        public boolean tryLock() {
            return DefaultIndexManager.this.obtain(new Awaitable(){

                @Override
                public boolean await(long time, TimeUnit unit) throws InterruptedException {
                    return IndexLock.this.lock.tryLock(time, unit);
                }
            });
        }

        public void unlock() {
            this.lock.unlock();
        }
    }

    private class IndexLocks {
        private final ReadWriteLock indexLock = new ReentrantReadWriteLock();
        final IndexLock readLock = new IndexLock(this.indexLock.readLock());
        final IndexLock writeLock = new IndexLock(this.indexLock.writeLock());

        private IndexLocks() {
        }
    }

    class ProjectBatcher
    implements IssuesBatcher {
        private final OfBizDelegator delegator;
        private final ImmutableList<Project> projects;
        private final IssueFactory issueFactory;

        @VisibleForTesting
        ProjectBatcher(OfBizDelegator delegator, IssueFactory issueFactory) {
            this.delegator = delegator;
            this.issueFactory = issueFactory;
            this.projects = ImmutableList.copyOf((Collection)DefaultIndexManager.this.projectManager.getProjectObjects());
        }

        @Override
        public Iterator<IssuesIterable> iterator() {
            return new ProjectsIterator();
        }

        class ProjectsIterator
        extends AbstractIterator<IssuesIterable> {
            private final UnmodifiableIterator<Project> projectsIt;

            ProjectsIterator() {
                this.projectsIt = ProjectBatcher.this.projects.iterator();
            }

            protected IssuesIterable computeNext() {
                if (!this.projectsIt.hasNext()) {
                    return (IssuesIterable)this.endOfData();
                }
                Project project = (Project)this.projectsIt.next();
                EntityExpr condition = new EntityExpr("project", EntityOperator.EQUALS, (Object)project.getId());
                return new DatabaseIssuesIterable(ProjectBatcher.this.delegator, ProjectBatcher.this.issueFactory, (EntityCondition)condition);
            }
        }
    }

    private static interface Awaitable {
        public boolean await(long var1, TimeUnit var3) throws InterruptedException;
    }
}

