/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.AttachmentJsonBeanConverter;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class AttachmentJsonBeanConverterImpl
implements AttachmentJsonBeanConverter {
    private final JiraBaseUrls urls;
    private final ThumbnailManager thumbnailManager;
    private final JiraAuthenticationContext authenticationContext;
    private final EmailFormatter emailFormatter;
    private final TimeZoneManager timeZoneManager;
    private final UserBeanFactory userBeanFactory;

    public AttachmentJsonBeanConverterImpl(JiraBaseUrls urls, ThumbnailManager thumbnailManager, JiraAuthenticationContext authenticationContext, EmailFormatter emailFormatter, TimeZoneManager timeZoneManager, UserBeanFactory userBeanFactory) {
        this.urls = urls;
        this.thumbnailManager = thumbnailManager;
        this.authenticationContext = authenticationContext;
        this.emailFormatter = emailFormatter;
        this.timeZoneManager = timeZoneManager;
        this.userBeanFactory = userBeanFactory;
    }

    public Collection<AttachmentJsonBean> shortBeans(Collection<Attachment> attachments) {
        ArrayList result = Lists.newArrayListWithCapacity((int)attachments.size());
        for (Attachment from : attachments) {
            result.add(this.shortBean(from));
        }
        return result;
    }

    public AttachmentJsonBean shortBean(Attachment attachment) {
        AttachmentJsonBean bean;
        if (attachment == null) {
            return null;
        }
        try {
            bean = new AttachmentJsonBean();
            bean.setSelf(this.urls.restApi2BaseUrl() + "attachment/" + JiraUrlCodec.encode((String)attachment.getId().toString()));
            bean.setId(attachment.getId().toString());
            bean.setFilename(attachment.getFilename());
            bean.setSize(attachment.getFilesize().longValue());
            bean.setMimeType(attachment.getMimetype());
            ApplicationUser author = attachment.getAuthorObject();
            bean.setAuthor(this.userBeanFactory.createBean(author, this.authenticationContext.getUser(), this.urls, this.emailFormatter, this.timeZoneManager));
            bean.setCreated((Date)attachment.getCreated());
            String encodedFilename = URLEncoder.encode(attachment.getFilename(), "UTF-8");
            bean.setContent(String.format("%s/secure/attachment/%s/%s", this.urls.baseUrl(), attachment.getId(), encodedFilename));
            ThumbnailedImage thumbnail = this.thumbnailManager.toThumbnailedImage(this.thumbnailManager.getThumbnail(attachment.getIssueObject(), attachment));
            if (thumbnail != null) {
                bean.setThumbnail(thumbnail.getImageURL());
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding file name", e);
        }
        return bean;
    }
}

