/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer;

import com.atlassian.jira.issue.fields.AffectedVersionsSystemField;
import com.atlassian.jira.issue.fields.ComponentsSystemField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FixVersionsSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class DefaultHackyFieldRendererRegistry
implements HackyFieldRendererRegistry {
    private static final String CUSTOM_FIELD_KEY_PREFIX = "com.atlassian.jira.plugin.system.customfieldtypes:";
    private static final Set<HackyRendererType> RENDERERS = ImmutableSet.of((Object)HackyRendererType.SELECT_LIST, (Object)HackyRendererType.FROTHER_CONTROL);
    private static final Map<Class<? extends OrderableField>, Set<HackyRendererType>> SYSTEM_FIELD_OVERRIDES = ImmutableMap.builder().put(FixVersionsSystemField.class, RENDERERS).put(AffectedVersionsSystemField.class, RENDERERS).put(ComponentsSystemField.class, RENDERERS).build();
    private static final Map<String, Set<HackyRendererType>> CUSTOM_FIELD_TYPE_OVERRIDES = ImmutableMap.builder().put((Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion", RENDERERS).build();

    public boolean shouldOverrideDefaultRenderers(OrderableField field) {
        return DefaultHackyFieldRendererRegistry.getRendererTypesOverride(field) != null;
    }

    public Set<HackyRendererType> getRendererTypes(OrderableField field) {
        Set<HackyRendererType> override = DefaultHackyFieldRendererRegistry.getRendererTypesOverride(field);
        if (override == null) {
            return Collections.emptySet();
        }
        return override;
    }

    @Nullable
    public HackyRendererType getDefaultRendererType(OrderableField field) {
        return this.shouldOverrideDefaultRenderers(field) ? HackyRendererType.FROTHER_CONTROL : null;
    }

    private static Set<HackyRendererType> getRendererTypesOverride(OrderableField field) {
        Assertions.notNull((String)"field", (Object)field);
        if (field instanceof CustomField) {
            String type = ((CustomField)field).getCustomFieldType().getKey();
            return CUSTOM_FIELD_TYPE_OVERRIDES.get(type);
        }
        return SYSTEM_FIELD_OVERRIDES.get(field.getClass());
    }
}

