/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.column;

import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutImpl;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.issue.fields.layout.column.UserColumnLayout;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;

public class UserColumnLayoutImpl
extends ColumnLayoutImpl
implements UserColumnLayout {
    private final ApplicationUser user;

    public UserColumnLayoutImpl(List<ColumnLayoutItem> columnLayoutItems, ApplicationUser user) {
        this(columnLayoutItems, user, ColumnLayout.ColumnConfig.USER);
    }

    public UserColumnLayoutImpl(List<ColumnLayoutItem> columnLayoutItems, ApplicationUser user, ColumnLayout.ColumnConfig columnConfig) {
        super(columnLayoutItems, columnConfig);
        this.user = user;
    }

    public List getColumnLayoutItems() {
        FieldManager fieldManager = this.getFieldManager();
        List<ColumnLayoutItem> internalList = this.getInternalList();
        ArrayList<ColumnLayoutItem> columnLayoutItems = new ArrayList<ColumnLayoutItem>(internalList.size());
        for (ColumnLayoutItem columnLayoutItem : internalList) {
            if (fieldManager.isCustomField((Field)columnLayoutItem.getNavigableField())) {
                CustomField customField = (CustomField)columnLayoutItem.getNavigableField();
                if (!CustomFieldUtils.isUserHasPermissionToProjects((CustomField)customField, (ApplicationUser)this.getUser())) continue;
                columnLayoutItems.add(columnLayoutItem);
                continue;
            }
            columnLayoutItems.add(columnLayoutItem);
        }
        return columnLayoutItems;
    }

    public ApplicationUser getUser() {
        return this.user;
    }
}

