/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context.persistence;

import com.atlassian.annotations.Internal;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersisterWorker;
import com.atlassian.jira.issue.fields.config.ConfigurationContext;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.FieldConfigSchemeIssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
@Internal
public class CachingFieldConfigContextPersister
implements FieldConfigContextPersister,
Startable {
    private static final Logger log = LoggerFactory.getLogger(CachingFieldConfigContextPersister.class);
    private final Cache<String, FieldConfigContextMap> fieldContextCache;
    private final Cache<Long, IssueTypeSet> configSchemeIssueTypeCache;
    private final FieldConfigContextPersisterWorker worker;
    private final OfBizDelegator ofBizDelegator;

    public CachingFieldConfigContextPersister(OfBizDelegator delegator, ProjectManager projectManager, CacheManager cacheManager) {
        this.ofBizDelegator = delegator;
        this.worker = new FieldConfigContextPersisterWorker(delegator, projectManager, cacheManager);
        this.fieldContextCache = cacheManager.getCache(CachingFieldConfigContextPersister.class.getName() + ".fieldContextCache", (CacheLoader)new FieldConfigContextCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
        this.configSchemeIssueTypeCache = cacheManager.getCache(CachingFieldConfigContextPersister.class.getName() + ".configSchemeIssueTypeCache", (CacheLoader)new ConfigSchemeIssueTypeCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
    }

    public void start() throws Exception {
    }

    @EventListener
    public void onClearCache(ClearCacheEvent clearCacheEvent) {
        this.invalidateAll();
    }

    public List<JiraContextNode> getAllContextsForConfigScheme(FieldConfigScheme fieldConfigScheme) {
        return this.worker.getAllContextsForConfigScheme(fieldConfigScheme);
    }

    public void removeContextsForConfigScheme(@Nonnull FieldConfigScheme fieldConfigScheme) {
        this.worker.removeContextsForConfigScheme(fieldConfigScheme);
        if (fieldConfigScheme.getField() != null) {
            this.fieldContextCache.remove((Object)fieldConfigScheme.getField().getId());
            this.configSchemeIssueTypeCache.remove((Object)fieldConfigScheme.getId());
        }
    }

    public void removeContextsForProject(Project project) {
        this.worker.removeContextsForProject(project);
        this.invalidateAll();
    }

    @Nullable
    public Long getRelevantConfigSchemeId(@Nonnull IssueContext issueContext, @Nonnull String fieldId) {
        Long schemeId = this.getRelevantConfigSchemeId(issueContext.getProjectObject(), fieldId, true);
        if (schemeId != null) {
            IssueTypeSet issueTypeSet = (IssueTypeSet)this.configSchemeIssueTypeCache.get((Object)schemeId);
            if (issueTypeSet == null) {
                throw new IllegalStateException("configSchemeIssueTypeCache failed to retrieve IssueTypeSet for schemeId " + schemeId);
            }
            if (issueTypeSet.includesIssueType(issueContext.getIssueTypeId())) {
                return schemeId;
            }
        }
        return null;
    }

    @Nullable
    public Long getRelevantConfigSchemeId(Project project, @Nonnull String fieldId, boolean lookUpParentContexts) {
        FieldConfigContextMap fieldConfigContextMap = (FieldConfigContextMap)this.fieldContextCache.get((Object)fieldId);
        if (fieldConfigContextMap == null) {
            throw new IllegalStateException("fieldContextCache failed to retrieve FieldConfigContextMap for fieldId " + fieldId);
        }
        return fieldConfigContextMap.getConfigSchemeIdForProject(project, lookUpParentContexts);
    }

    public void store(String fieldId, JiraContextNode contextNode, FieldConfigScheme fieldConfigScheme) {
        Set uniqueSchemeIds = ((FieldConfigContextMap)this.fieldContextCache.get((Object)fieldId)).getUniqueSchemeIds();
        this.worker.store(fieldId, contextNode, fieldConfigScheme);
        this.fieldContextCache.remove((Object)fieldId);
        for (Long schemeId : uniqueSchemeIds) {
            this.configSchemeIssueTypeCache.remove((Object)schemeId);
        }
    }

    public void store(String fieldId, Collection<? extends JiraContextNode> contextNodes, FieldConfigScheme fieldConfigScheme) {
        Set uniqueSchemeIds = ((FieldConfigContextMap)this.fieldContextCache.get((Object)fieldId)).getUniqueSchemeIds();
        for (JiraContextNode jiraContextNode : contextNodes) {
            this.worker.store(fieldId, jiraContextNode, fieldConfigScheme);
        }
        this.fieldContextCache.remove((Object)fieldId);
        for (Long l : uniqueSchemeIds) {
            this.configSchemeIssueTypeCache.remove((Object)l);
        }
    }

    private void invalidateAll() {
        this.worker.invalidateAll();
        this.fieldContextCache.removeAll();
        this.configSchemeIssueTypeCache.removeAll();
        if (log.isTraceEnabled()) {
            log.trace("called invalidateAll()", new Throwable());
        }
    }

    private static class IssueTypeSet {
        private final Set<String> issueTypeIds;

        public IssueTypeSet(Set<String> issueTypeIds) {
            this.issueTypeIds = issueTypeIds;
        }

        @Nonnull
        public static IssueTypeSet from(List<FieldConfigSchemeIssueType> issueTypeConfigs) {
            HashSet<String> issueTypeIds = new HashSet<String>(issueTypeConfigs.size());
            for (FieldConfigSchemeIssueType issueTypeConfig : issueTypeConfigs) {
                if (issueTypeConfig.getIssueTypeId() == null) {
                    return new IssueTypeSet(null);
                }
                issueTypeIds.add(issueTypeConfig.getIssueTypeId());
            }
            return new IssueTypeSet(issueTypeIds);
        }

        public boolean includesIssueType(String issueTypeId) {
            return this.issueTypeIds == null || this.issueTypeIds.contains("-1") || this.issueTypeIds.contains(issueTypeId);
        }
    }

    private class ConfigSchemeIssueTypeCacheLoader
    implements CacheLoader<Long, IssueTypeSet> {
        private ConfigSchemeIssueTypeCacheLoader() {
        }

        @Nonnull
        public IssueTypeSet load(@Nonnull Long schemeId) {
            List<FieldConfigSchemeIssueType> issueTypeConfigs = Select.from(Entity.FIELD_CONFIG_SCHEME_ISSUE_TYPE).whereEqual("fieldconfigscheme", schemeId).runWith(CachingFieldConfigContextPersister.this.ofBizDelegator).asList();
            return IssueTypeSet.from(issueTypeConfigs);
        }
    }

    private static class FieldConfigContextMap {
        private final Map<Long, Long> projectIdToSchemeIdMap;

        private FieldConfigContextMap(Map<Long, Long> projectIdToSchemeIdMap) {
            this.projectIdToSchemeIdMap = projectIdToSchemeIdMap;
        }

        private Long getConfigSchemeIdForProject(Project project, boolean lookUpParentContexts) {
            Long projectId = project == null ? null : project.getId();
            Long schemeId = this.projectIdToSchemeIdMap.get(projectId);
            if (project == null || !lookUpParentContexts) {
                return schemeId;
            }
            if (schemeId == null) {
                schemeId = this.projectIdToSchemeIdMap.get(null);
            }
            return schemeId;
        }

        private Set<Long> getUniqueSchemeIds() {
            return new HashSet<Long>(this.projectIdToSchemeIdMap.values());
        }
    }

    private class FieldConfigContextCacheLoader
    implements CacheLoader<String, FieldConfigContextMap> {
        private FieldConfigContextCacheLoader() {
        }

        @Nonnull
        public FieldConfigContextMap load(@Nonnull String fieldId) {
            List configurationContexts = Select.from(Entity.CONFIGURATION_CONTEXT).whereEqual("key", fieldId).runWith(CachingFieldConfigContextPersister.this.ofBizDelegator).asList();
            HashMap<Long, Long> projectIdToSchemeIdMap = new HashMap<Long, Long>(configurationContexts.size());
            for (ConfigurationContext configurationContext : configurationContexts) {
                projectIdToSchemeIdMap.put(configurationContext.getProjectId(), configurationContext.getFieldConfigSchemeId());
            }
            return new FieldConfigContextMap(projectIdToSchemeIdMap);
        }
    }
}

