/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store.strategy.move;

import com.atlassian.jira.util.RuntimeIOException;
import com.google.common.base.Function;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtilsWrapper {
    private static final Logger log = LoggerFactory.getLogger(IOUtilsWrapper.class);

    public InputStream openInputStream(File file) {
        try {
            return FileUtils.openInputStream((File)file);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public FileOutputStream openOutputStream(File file) {
        try {
            return FileUtils.openOutputStream((File)file);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public int copy(InputStream inputStream, OutputStream output) {
        try {
            return IOUtils.copy((InputStream)inputStream, (OutputStream)output);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public File createTempFile(String prefix, String suffix) {
        try {
            return File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> A processTemporaryFile(String prefix, String suffix, Function<File, A> operation) {
        File temporaryFile = this.createTempFile(prefix, suffix);
        try {
            Object object = operation.apply((Object)temporaryFile);
            return (A)object;
        }
        finally {
            boolean deleted = temporaryFile.delete();
            if (!deleted) {
                log.warn("Failed to delete temporary file: " + temporaryFile);
            }
        }
    }
}

