/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store.provider;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreAttachmentStoreModeProvider {
    private static final Logger log = LoggerFactory.getLogger(BlobStoreAttachmentStoreModeProvider.class);
    @VisibleForTesting
    public static final String INITIAL_MODE_SYSPROP = "com.atlassian.jira.DualAttachmentStore.initialMode";
    @VisibleForTesting
    static final String FS_ONLY_FLAG = "com.atlassian.jira.FS_ATTACHMENTS_ONLY";
    @VisibleForTesting
    static final String REMOTE_ONLY_FLAG = "com.atlassian.jira.REMOTE_ATTACHMENTS_ONLY";
    @VisibleForTesting
    static final String FS_PRIMARY_FLAG = "com.atlassian.jira.FS_ATTACHMENTS_PRIMARY";
    @VisibleForTesting
    static final String REMOTE_PRIMARY_FLAG = "com.atlassian.jira.REMOTE_ATTACHMENTS_PRIMARY";
    private final FeatureManager featureManager;
    private final JiraProperties jiraProperties;

    public BlobStoreAttachmentStoreModeProvider(@Nonnull FeatureManager featureManager, @Nonnull JiraProperties jiraProperties) {
        this.featureManager = featureManager;
        this.jiraProperties = jiraProperties;
    }

    private boolean enabled(String featureKey) {
        return this.featureManager.isEnabled(featureKey);
    }

    @Nonnull
    public Mode mode() {
        Mode mode = this.enabled(REMOTE_ONLY_FLAG) ? Mode.REMOTE_ONLY : (this.enabled(REMOTE_PRIMARY_FLAG) ? Mode.REMOTE_PRIMARY : (this.enabled(FS_PRIMARY_FLAG) ? Mode.FS_PRIMARY : (this.enabled(FS_ONLY_FLAG) ? Mode.FS_ONLY : this.getInitialMode())));
        log.debug("Using DualAttachmentStoreProvider mode '{}'", (Object)mode);
        return mode;
    }

    @Nonnull
    private Mode getInitialMode() {
        Mode mode;
        String initialMode = this.jiraProperties.getProperty(INITIAL_MODE_SYSPROP, Mode.FS_ONLY.name());
        try {
            mode = Mode.valueOf(initialMode);
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid initial DualAttachmentStoreProvider mode specified in sysprop {}: '{}'. Falling back to FS_ONLY.", (Object)INITIAL_MODE_SYSPROP, (Object)initialMode);
            mode = Mode.FS_ONLY;
        }
        return mode;
    }

    public static enum Mode {
        FS_ONLY,
        FS_PRIMARY,
        REMOTE_PRIMARY,
        REMOTE_ONLY;

    }
}

