/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.io;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.io.SessionNotFoundException;
import com.atlassian.jira.io.SessionTempFile;
import com.atlassian.jira.io.SessionTempFiles;
import com.atlassian.jira.io.TempFileFactory;
import com.atlassian.jira.util.AttachmentConfig;
import com.atlassian.jira.util.PathUtils;
import com.atlassian.jira.web.HttpServletVariables;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;

public class TempFileFactoryImpl
implements TempFileFactory {
    private final HttpServletVariables httpServletVariables;
    private final AttachmentConfig attachmentConfig;

    public TempFileFactoryImpl(HttpServletVariables httpServletVariables, AttachmentConfig attachmentConfig) {
        this.httpServletVariables = httpServletVariables;
        this.attachmentConfig = attachmentConfig;
    }

    @Nonnull
    public SessionTempFile makeSessionTempFile(String path) throws IllegalArgumentException, IllegalStateException {
        File file = this.checkFileExists(path);
        HttpSession httpSession = this.httpServletVariables.getHttpSession();
        List<String> allowedDirs = this.getAllowedTempFileDirs();
        try {
            for (String dir : allowedDirs) {
                if (!PathUtils.isPathInSecureDir((String)dir, (String)file.getAbsolutePath())) continue;
                return SessionTempFiles.forSession(httpSession).createTempFile(file);
            }
            throw new IllegalArgumentException("Path is not in a temporary directory: " + path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public SessionTempFile getSessionTempFile(String path) throws IllegalArgumentException, SessionNotFoundException {
        File file = this.findFile(path);
        HttpSession httpSession = this.httpServletVariables.getHttpSession();
        return SessionTempFiles.forSession(httpSession).getTempFile(file);
    }

    private List<String> getAllowedTempFileDirs() {
        return ImmutableList.of((Object)JiraSystemProperties.getInstance().getProperty("java.io.tmpdir"), (Object)this.attachmentConfig.getTemporaryAttachmentDirectory().getAbsolutePath());
    }

    @Nonnull
    private File findFile(String location) {
        File file = new File(location);
        if (!file.isAbsolute()) {
            file = new File(JiraSystemProperties.getInstance().getProperty("java.io.tmpdir"), location);
        }
        return file;
    }

    @Nonnull
    private File checkFileExists(String location) {
        File file = this.findFile(location);
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + location);
        }
        return file;
    }
}

