/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.request;

import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequest;
import com.atlassian.jira.index.request.ReindexRequestManager;
import com.atlassian.jira.index.request.ReindexRequestService;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class DefaultReindexRequestService
implements ReindexRequestService {
    private static final Logger log = Logger.getLogger(DefaultReindexRequestService.class);
    private final ReindexRequestManager reindexRequestManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public DefaultReindexRequestService(ReindexRequestManager reindexRequestManager, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.reindexRequestManager = reindexRequestManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Nonnull
    public Set<ReindexRequest> processRequests(Set<ReindexRequestType> reindexRequestTypes, boolean runInBackground) throws PermissionException {
        return this.processRequests(false, reindexRequestTypes, runInBackground);
    }

    @Nonnull
    public Set<ReindexRequest> processRequestsAndWait(Set<ReindexRequestType> reindexRequestTypes, boolean runInBackground) throws PermissionException {
        return this.processRequests(true, reindexRequestTypes, runInBackground);
    }

    private Set<ReindexRequest> processRequests(boolean waitForCompletion, Set<ReindexRequestType> reindexRequestTypes, boolean runInBackground) throws PermissionException {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (!this.permissionManager.hasPermission(0, user)) {
            throw new PermissionException();
        }
        if (this.reindexRequestManager.isReindexInProgress()) {
            throw new IllegalStateException(this.i18n().getText("admin.indexing.alreadyinprogress"));
        }
        Set requests = this.reindexRequestManager.processPendingRequests(waitForCompletion, reindexRequestTypes, runInBackground);
        return ImmutableSet.copyOf((Collection)requests);
    }

    @Nonnull
    public ReindexRequest requestReindex(@Nonnull ReindexRequestType type, @Nonnull Set<AffectedIndex> affectedIndexes, @Nonnull Set<SharedEntityType> entityTypes) {
        return this.reindexRequestManager.requestReindex(type, affectedIndexes, entityTypes);
    }

    @Nullable
    public ReindexRequest getReindexProgress(long requestId) {
        Set<ReindexRequest> results = this.getReindexProgress(Collections.singleton(requestId));
        if (results.isEmpty()) {
            return null;
        }
        return results.iterator().next();
    }

    @Nonnull
    public Set<ReindexRequest> getReindexProgress(@Nonnull Set<Long> requestIds) {
        return this.reindexRequestManager.getReindexProgress(requestIds);
    }

    public boolean isReindexRequested() {
        return this.reindexRequestManager.isReindexRequested();
    }

    private I18nHelper i18n() {
        return this.jiraAuthenticationContext.getI18nHelper();
    }
}

