/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.property;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.index.IndexDocumentConfiguration;
import com.atlassian.jira.index.property.JqlAlias;
import com.atlassian.jira.index.property.JqlAliasFactory;
import com.atlassian.jira.index.property.JqlAliasManager;
import com.atlassian.jira.index.property.PluginIndexConfiguration;
import com.atlassian.jira.index.property.PluginIndexConfigurationManager;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.List;

public class DefaultJqlAliasManager
implements JqlAliasManager {
    private final PluginIndexConfigurationManager pluginIndexConfigurationManager;
    private final JqlAliasFactory jqlAliasFactory;

    public DefaultJqlAliasManager(PluginIndexConfigurationManager pluginIndexConfigurationManager, JqlAliasFactory jqlAliasFactory) {
        this.pluginIndexConfigurationManager = pluginIndexConfigurationManager;
        this.jqlAliasFactory = jqlAliasFactory;
    }

    @Override
    public Iterable<JqlAlias> getJqlAliases() {
        Iterable<PluginIndexConfiguration> indexConfigurations = this.pluginIndexConfigurationManager.getDocumentsForEntity(EntityPropertyType.ISSUE_PROPERTY.getDbEntityName());
        Iterable allKeyConfigurations = Iterables.transform(indexConfigurations, (Function)new Function<PluginIndexConfiguration, Iterable<KeyConfigurationWrapper>>(){

            public Iterable<KeyConfigurationWrapper> apply(PluginIndexConfiguration pluginIndexConfiguration) {
                List keyConfigurations = pluginIndexConfiguration.getIndexDocumentConfiguration().getKeyConfigurations();
                return Iterables.transform((Iterable)keyConfigurations, KeyConfigurationWrapper.build(pluginIndexConfiguration));
            }
        });
        return this.createAliases(Iterables.concat((Iterable)allKeyConfigurations));
    }

    private Iterable<JqlAlias> createAliases(Iterable<KeyConfigurationWrapper> indexConfigurations) {
        Iterable aliases = Iterables.transform(indexConfigurations, (Function)new Function<KeyConfigurationWrapper, Iterable<Option<JqlAlias>>>(){

            public Iterable<Option<JqlAlias>> apply(final KeyConfigurationWrapper keyConfigurationWrapper) {
                return Iterables.transform((Iterable)keyConfigurationWrapper.getKeyConfiguration().getExtractorConfigurations(), (Function)new Function<IndexDocumentConfiguration.ExtractConfiguration, Option<JqlAlias>>(){

                    public Option<JqlAlias> apply(final IndexDocumentConfiguration.ExtractConfiguration extractConfiguration) {
                        return extractConfiguration.getAlias().map((Function)new Function<String, JqlAlias>(){

                            public JqlAlias apply(String alias) {
                                return DefaultJqlAliasManager.this.jqlAliasFactory.createAlias(keyConfigurationWrapper.pluginKey, keyConfigurationWrapper.getKeyConfiguration().getPropertyKey(), extractConfiguration, alias);
                            }
                        });
                    }
                });
            }
        });
        return Options.flatten((Iterable)Iterables.concat((Iterable)aliases));
    }

    private static class KeyConfigurationWrapper {
        private final String pluginKey;
        private final String moduleKey;
        private final IndexDocumentConfiguration.KeyConfiguration keyConfiguration;

        private KeyConfigurationWrapper(String pluginKey, String moduleKey, IndexDocumentConfiguration.KeyConfiguration keyConfiguration) {
            this.pluginKey = pluginKey;
            this.moduleKey = moduleKey;
            this.keyConfiguration = keyConfiguration;
        }

        public IndexDocumentConfiguration.KeyConfiguration getKeyConfiguration() {
            return this.keyConfiguration;
        }

        public static Function<IndexDocumentConfiguration.KeyConfiguration, KeyConfigurationWrapper> build(final PluginIndexConfiguration pluginIndexConfiguration) {
            return new Function<IndexDocumentConfiguration.KeyConfiguration, KeyConfigurationWrapper>(){

                public KeyConfigurationWrapper apply(IndexDocumentConfiguration.KeyConfiguration keyConfiguration) {
                    return new KeyConfigurationWrapper(pluginIndexConfiguration.getPluginKey(), pluginIndexConfiguration.getModuleKey(), keyConfiguration);
                }
            };
        }
    }
}

