/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.AtomicSupplier;
import com.atlassian.jira.index.CloseableIndex;
import com.atlassian.jira.index.FutureResult;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.Writer;
import com.atlassian.jira.util.RuntimeInterruptedException;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.SettableFuture;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;

class QueueingIndex
implements CloseableIndex {
    private static final int DEFAULT_QUEUE_BUFFER = 128;
    private final Task task = new Task();
    private final AtomicSupplier<Thread> indexerThread = new AtomicSupplier<Thread>(){

        @Override
        @Nonnull
        protected Thread create() {
            Thread thread = QueueingIndex.this.threadFactory.newThread(QueueingIndex.this.task);
            thread.start();
            return thread;
        }
    };
    private final ThreadFactory threadFactory;
    private final CloseableIndex delegate;
    @VisibleForTesting
    final BlockingQueue<FutureOperation> queue;

    QueueingIndex(@Nonnull String name, @Nonnull CloseableIndex delegate, int maxQueueSize) {
        this(ThreadFactories.namedThreadFactory((String)Assertions.notNull((String)"name", (Object)name) + "-indexQueue"), delegate, maxQueueSize);
    }

    @VisibleForTesting
    QueueingIndex(@Nonnull ThreadFactory threadFactory, @Nonnull CloseableIndex delegate, int maxQueueSize) {
        this.threadFactory = (ThreadFactory)Assertions.notNull((String)"threadFactory", (Object)threadFactory);
        this.delegate = (CloseableIndex)Assertions.notNull((String)"delegate", (Object)delegate);
        this.queue = new LinkedBlockingQueue<FutureOperation>(maxQueueSize);
    }

    @Override
    @Nonnull
    public Index.Result perform(@Nonnull Index.Operation operation) {
        FutureOperation future = new FutureOperation(operation);
        try {
            this.queue.put(future);
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        this.ensureRunning();
        return new FutureResult((Future<Index.Result>)((Object)future));
    }

    @Override
    public void close() {
        Thread thread = this.indexerThread.get();
        try {
            while (thread.isAlive()) {
                this.task.interrupt(thread);
                thread.join(100L);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        finally {
            this.indexerThread.compareAndSetNull(thread);
            this.delegate.close();
        }
    }

    private void ensureRunning() {
        Thread thread;
        while (!(thread = this.indexerThread.get()).isAlive()) {
            this.indexerThread.compareAndSetNull(thread);
        }
        return;
    }

    private static void selfInterrupt() {
        Thread.currentThread().interrupt();
    }

    static class CompositeOperation
    extends Index.Operation {
        private final List<FutureOperation> operations;

        CompositeOperation(List<FutureOperation> operations) {
            this.operations = Collections.unmodifiableList(operations);
        }

        public void set(Index.Result result) {
            for (FutureOperation future : this.operations) {
                future.set(result);
            }
        }

        @Override
        void perform(@Nonnull Writer writer) throws IOException {
            Iterator<FutureOperation> iter = this.operations.iterator();
            try {
                while (iter.hasNext()) {
                    iter.next().operation.perform(writer);
                }
            }
            catch (RuntimeException re) {
                CompositeOperation.cancelTheRest(iter, re);
                throw re;
            }
            catch (IOException ioe) {
                CompositeOperation.cancelTheRest(iter, ioe);
                throw ioe;
            }
        }

        private static void cancelTheRest(Iterator<FutureOperation> iter, Throwable cause) {
            CancellationException ce = new CancellationException("Cancelled composite indexing operation due to unhandled exception " + cause);
            ce.initCause(cause);
            while (iter.hasNext()) {
                iter.next().setException(ce);
            }
        }

        @Override
        Index.UpdateMode mode() {
            for (FutureOperation future : this.operations) {
                if (future.mode() != Index.UpdateMode.BATCH) continue;
                return Index.UpdateMode.BATCH;
            }
            return Index.UpdateMode.INTERACTIVE;
        }
    }

    static class FutureOperation
    extends SettableFuture<Index.Result> {
        private final Index.Operation operation;

        FutureOperation(Index.Operation operation) {
            this.operation = (Index.Operation)Assertions.notNull((String)"operation", (Object)operation);
        }

        Index.UpdateMode mode() {
            return this.operation.mode();
        }
    }

    class Task
    implements Runnable {
        Task() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    this.index();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        synchronized void interrupt(Thread thread) {
            thread.interrupt();
        }

        synchronized void perform(CompositeOperation operation) {
            boolean interrupted = Thread.interrupted();
            try {
                operation.set(QueueingIndex.this.delegate.perform(operation));
            }
            finally {
                if (interrupted) {
                    QueueingIndex.selfInterrupt();
                }
            }
        }

        void index() throws InterruptedException {
            ArrayList<FutureOperation> list = new ArrayList<FutureOperation>(128);
            list.add(QueueingIndex.this.queue.take());
            QueueingIndex.this.queue.drainTo(list);
            this.perform(new CompositeOperation(list));
        }
    }
}

