/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.core;

import com.atlassian.jira.imports.project.core.ProjectImportData;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.util.AoImportTemporaryFiles;
import com.atlassian.jira.imports.project.util.ProjectImportTemporaryFiles;
import java.io.File;

public class ProjectImportDataImpl
implements ProjectImportData {
    private final ProjectImportTemporaryFiles temporaryFiles;
    private final AoImportTemporaryFiles aoImportTemporaryFiles;
    private final int issueCount;
    private final int fileAttachmentCount;
    private final int changeItemEntityCount;
    private final int nonIssueEntityCount;
    private final int issueRelatedEntitiesCount;
    private final int customFieldValuesCount;
    private final ProjectImportMapper projectImportMapper;
    private int validAttachmentCount;

    public ProjectImportDataImpl(ProjectImportMapper projectImportMapper, ProjectImportTemporaryFiles temporaryFiles, AoImportTemporaryFiles aoImportTemporaryFiles, int issueCount, int customFieldValuesCount, int issueRelatedEntitiesCount, int fileAttachmentCount, int changeItemEntityCount, int nonIssueEntityCount) {
        this.temporaryFiles = temporaryFiles;
        this.aoImportTemporaryFiles = aoImportTemporaryFiles;
        this.issueCount = issueCount;
        this.customFieldValuesCount = customFieldValuesCount;
        this.issueRelatedEntitiesCount = issueRelatedEntitiesCount;
        this.projectImportMapper = projectImportMapper;
        this.fileAttachmentCount = fileAttachmentCount;
        this.changeItemEntityCount = changeItemEntityCount;
        this.nonIssueEntityCount = nonIssueEntityCount;
    }

    @Override
    public ProjectImportTemporaryFiles getTemporaryFiles() {
        return this.temporaryFiles;
    }

    @Override
    public AoImportTemporaryFiles getTemporaryAoFiles() {
        return this.aoImportTemporaryFiles;
    }

    @Override
    public String getPathToEntityXml(String entityName) {
        File entityXmlFile = this.temporaryFiles.getEntityXmlFile(entityName);
        return entityXmlFile == null ? null : entityXmlFile.getAbsolutePath();
    }

    @Override
    public int getIssueEntityCount() {
        return this.issueCount;
    }

    @Override
    public int getFileAttachmentEntityCount() {
        return this.fileAttachmentCount;
    }

    @Override
    public int getIssueRelatedEntityCount() {
        return this.issueRelatedEntitiesCount;
    }

    @Override
    public int getCustomFieldValuesEntityCount() {
        return this.customFieldValuesCount;
    }

    @Override
    public int getChangeItemEntityCount() {
        return this.changeItemEntityCount;
    }

    @Override
    public ProjectImportMapper getProjectImportMapper() {
        return this.projectImportMapper;
    }

    @Override
    public void setValidAttachmentsCount(int validAttachmentCount) {
        this.validAttachmentCount = validAttachmentCount;
    }

    @Override
    public int getValidAttachmentsCount() {
        return this.validAttachmentCount;
    }

    @Override
    public int getNonIssueEntityCount() {
        return this.nonIssueEntityCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectImportDataImpl that = (ProjectImportDataImpl)o;
        if (this.customFieldValuesCount != that.customFieldValuesCount) {
            return false;
        }
        if (this.fileAttachmentCount != that.fileAttachmentCount) {
            return false;
        }
        if (this.issueCount != that.issueCount) {
            return false;
        }
        if (this.issueRelatedEntitiesCount != that.issueRelatedEntitiesCount) {
            return false;
        }
        if (this.projectImportMapper != null ? !this.projectImportMapper.equals(that.projectImportMapper) : that.projectImportMapper != null) {
            return false;
        }
        return !(this.temporaryFiles != null ? !this.temporaryFiles.equals(that.temporaryFiles) : that.temporaryFiles != null);
    }

    public int hashCode() {
        int result = this.temporaryFiles != null ? this.temporaryFiles.hashCode() : 0;
        result = 31 * result + this.issueCount;
        result = 31 * result + this.fileAttachmentCount;
        result = 31 * result + this.issueRelatedEntitiesCount;
        result = 31 * result + this.customFieldValuesCount;
        result = 31 * result + (this.projectImportMapper != null ? this.projectImportMapper.hashCode() : 0);
        return result;
    }
}

