/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.image.separator;

import com.atlassian.jira.image.separator.HeaderSeparatorService;
import com.atlassian.jira.image.util.ImageUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHeaderSeparatorService
implements HeaderSeparatorService {
    private static final Logger log = LoggerFactory.getLogger(DefaultHeaderSeparatorService.class);
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final Color DEFAULT_BG_COLOR = new Color(255, 255, 255, 0);
    private final ImageUtils imageUtils;

    public DefaultHeaderSeparatorService(ImageUtils imageUtils) {
        this.imageUtils = imageUtils;
    }

    public byte[] getSeparator(String colorHex, String backgroundColorHex) {
        BufferedImage image = new BufferedImage(1, 13, 2);
        Graphics2D graphics = image.createGraphics();
        Color backgroundColor = this.imageUtils.getColor(backgroundColorHex, false);
        graphics.setColor(backgroundColor == null ? DEFAULT_BG_COLOR : backgroundColor);
        graphics.drawLine(0, 0, 0, 12);
        Color color = this.imageUtils.getColor(colorHex, false);
        graphics.setColor(color == null ? DEFAULT_COLOR : color);
        graphics.drawLine(0, 1, 0, 1);
        graphics.drawLine(0, 3, 0, 3);
        graphics.drawLine(0, 5, 0, 5);
        graphics.drawLine(0, 7, 0, 7);
        graphics.drawLine(0, 9, 0, 9);
        graphics.drawLine(0, 11, 0, 11);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
        }
        catch (IOException e) {
            log.error("Wow!  An IOException occured with a ByteArrayOutputStream.  Is that even possible?", (Throwable)e);
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

