/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.help;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.help.HelpUrlsLoader;
import com.atlassian.jira.help.HelpUrlsParser;
import com.atlassian.jira.help.ImmutableHelpUrls;
import com.atlassian.jira.help.LocalHelpUrls;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.resourcebundle.ResourceBundleLoader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHelpUrlsLoader
implements HelpUrlsLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHelpUrlsLoader.class);
    private static final String DEFAULT_HELP_URL = "https://confluence.atlassian.com/display/JIRA/";
    private final ResourceBundleLoader loader;
    private final JiraAuthenticationContext ctx;
    private final FeatureManager featureManager;
    private final LocalHelpUrls localHelpUrls;
    private final I18nHelper.BeanFactory i18n;
    private final HelpUrlsParser parser;

    public DefaultHelpUrlsLoader(ResourceBundleLoader loader, JiraAuthenticationContext ctx, FeatureManager featureManager, LocalHelpUrls localHelpUrls, I18nHelper.BeanFactory i18n, HelpUrlsParser parser) {
        this.i18n = i18n;
        this.parser = parser;
        this.loader = loader.helpText();
        this.ctx = ctx;
        this.featureManager = featureManager;
        this.localHelpUrls = localHelpUrls;
    }

    @Override
    @Nonnull
    public HelpUrlsLoader.HelpUrlsLoaderKey keyForCurrentUser() {
        return new LoaderKey(this.ctx.getLocale(), this.featureManager.isOnDemand());
    }

    @Override
    public HelpUrls apply(HelpUrlsLoader.HelpUrlsLoaderKey input) {
        Assertions.notNull((Object)input);
        if (input instanceof LoaderKey) {
            LOG.debug("Loading help urls for key '{}'.", (Object)input);
            return this.apply((LoaderKey)input);
        }
        throw new IllegalArgumentException("'input' was not created by a call to keyForCurrentUser.");
    }

    private HelpUrls apply(LoaderKey key) {
        HelpUrls externalHelpUrls = this.getExternalHelpUrls(key);
        return new ImmutableHelpUrls(externalHelpUrls.getDefaultUrl(), Iterables.concat(this.localHelpUrls.load(), (Iterable)externalHelpUrls));
    }

    private HelpUrls getExternalHelpUrls(LoaderKey key) {
        return this.parser.onDemand(key.onDemand).defaultUrl(DEFAULT_HELP_URL, this.i18n.getInstance(key.locale).getText("jira.help.paths.help.title")).parse(this.loader.locale(key.locale).load().getData());
    }

    @VisibleForTesting
    static class LoaderKey
    implements HelpUrlsLoader.HelpUrlsLoaderKey {
        private final Locale locale;
        private final boolean onDemand;

        @VisibleForTesting
        LoaderKey(Locale locale, boolean onDemand) {
            this.locale = locale;
            this.onDemand = onDemand;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoaderKey getKey = (LoaderKey)o;
            if (this.onDemand != getKey.onDemand) {
                return false;
            }
            return this.locale.equals(getKey.locale);
        }

        public int hashCode() {
            int result = this.locale.hashCode();
            result = 31 * result + (this.onDemand ? 1 : 0);
            return result;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("locale", (Object)this.locale).append("onDemand", this.onDemand).toString();
        }
    }
}

