/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.JodaFormatterSupplier;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

class DateTimeRFC822DateTimeFormatter
implements DateTimeFormatStrategy {
    private final JodaFormatterSupplier cache;
    public static String RSS_RFC822_FORMAT = "EEE, d MMM yyyy HH:mm:ss Z";

    public DateTimeRFC822DateTimeFormatter(JodaFormatterSupplier cache) {
        this.cache = cache;
    }

    @Override
    public String format(DateTime dateTime, Locale locale) {
        DateTimeFormatter formatter = this.cache.get(new JodaFormatterSupplier.Key(RSS_RFC822_FORMAT, locale));
        return formatter.print((ReadableInstant)dateTime);
    }

    @Override
    public Date parse(String text, DateTimeZone timeZone, Locale locale) throws UnsupportedOperationException {
        DateTimeFormatter formatter = this.cache.get(new JodaFormatterSupplier.Key(RSS_RFC822_FORMAT, locale)).withZone(timeZone);
        return formatter.parseDateTime(text).toDate();
    }

    @Override
    public DateTimeStyle style() {
        return DateTimeStyle.RSS_RFC822_DATE_TIME;
    }

    @Override
    public String pattern() {
        return RSS_RFC822_FORMAT;
    }
}

