/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroup;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupCache;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupDao;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupCache;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.Visitor;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.locks.Lock;

class EagerOfBizGroupCache
extends UserOrGroupCache<OfBizGroup>
implements OfBizGroupCache {
    @VisibleForTesting
    static final CacheSettings GROUP_CACHE_SETTINGS = new CacheSettingsBuilder().unflushable().replicateViaCopy().build();
    private static final String LOAD_GROUP_CACHE_LOCK = EagerOfBizGroupCache.class.getName() + ".loadGroupCacheLock";
    private final ClusterLockService clusterLockService;
    private final CacheManager cacheManager;
    private final DirectoryDao directoryDao;
    private final OfBizDelegator ofBizDelegator;

    EagerOfBizGroupCache(ClusterLockService clusterLockService, CacheManager cacheManager, DirectoryDao directoryDao, OfBizDelegator ofBizDelegator) {
        super("Group");
        this.clusterLockService = clusterLockService;
        this.cacheManager = cacheManager;
        this.directoryDao = directoryDao;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public Lock getLock() {
        return this.clusterLockService.getLockForName(LOAD_GROUP_CACHE_LOCK);
    }

    @Override
    public Cache<DirectoryEntityKey, OfBizGroup> createCache() {
        return this.cacheManager.getCache(EagerOfBizGroupCache.class.getName() + ".groupCache", null, GROUP_CACHE_SETTINGS);
    }

    @Override
    public long countAllUsingDatabase() {
        long count = 0L;
        for (Directory directory : this.directoryDao.findAll()) {
            count += Select.id().from("Group").whereEqual("directoryId", directory.getId()).runWith(this.ofBizDelegator).count();
        }
        return count;
    }

    @Override
    public void visitAllUsingDatabase(Visitor<OfBizGroup> visitor) {
        Visitor gvVisitor = Functions.mappedVisitor(OfBizGroupDao.TO_GROUP_FUNCTION, visitor);
        for (Directory directory : this.directoryDao.findAll()) {
            Select.columns(OfBizGroup.SUPPORTED_FIELDS).from("Group").whereEqual("directoryId", directory.getId()).runWith(this.ofBizDelegator).visitWith(gvVisitor);
        }
    }
}

