/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.beehive.core.ManagedClusterLock;
import com.atlassian.beehive.core.stats.StatisticsKey;
import com.atlassian.instrumentation.ExternalCounter;
import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ClusterLockInstruments {
    private final ManagedClusterLock clusterLock;
    final String name;

    public ClusterLockInstruments(ManagedClusterLock clusterLock) {
        this.clusterLock = (ManagedClusterLock)Assertions.notNull((String)"clusterLock", (Object)clusterLock);
        this.name = clusterLock.getName();
    }

    @Nonnull
    public List<Instrument> getInstruments() {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.getStatistics(), (Function)new ToInstrument()));
    }

    private Set<Map.Entry<StatisticsKey, Long>> getStatistics() {
        return this.clusterLock.getStatistics().entrySet();
    }

    public String getName() {
        return this.name;
    }

    static class StatisticValue
    implements ExternalValue {
        private final long value;

        StatisticValue(Long value) {
            this.value = value != null ? value : 0L;
        }

        public long getValue() {
            return this.value;
        }
    }

    class ToInstrument
    implements Function<Map.Entry<StatisticsKey, Long>, Instrument> {
        ToInstrument() {
        }

        public Instrument apply(Map.Entry<StatisticsKey, Long> entry) {
            return this.apply(entry.getKey(), entry.getValue());
        }

        private Instrument apply(StatisticsKey key, Long value) {
            switch (key.getType()) {
                case COUNTER: {
                    return this.counter(key, value);
                }
            }
            return this.gauge(key, value);
        }

        private Instrument counter(StatisticsKey key, Long value) {
            return new ExternalCounter(ClusterLockInstruments.this.name + '.' + key.getLabel(), (ExternalValue)new StatisticValue(value));
        }

        private Instrument gauge(StatisticsKey key, Long value) {
            return new ExternalGauge(ClusterLockInstruments.this.name + '.' + key.getLabel(), (ExternalValue)new StatisticValue(value));
        }
    }
}

