/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.dataimport.ha.RemoteImportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ha.RemoteImportStartedEvent;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.Message;

public class EventMessageConsumer
implements ClusterMessageConsumer {
    public static final String IMPORT_STARTED = "Import Started";
    public static final String IMPORT_FINISHED = "Import Done";
    private final EventPublisher eventPublisher;

    public EventMessageConsumer(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public static Message importFinishedMessage(Boolean success) {
        return new Message(IMPORT_FINISHED, success.toString());
    }

    public static Message importStartedMessage() {
        return new Message(IMPORT_STARTED, null);
    }

    public void receive(String channel, String message, String senderId) {
        if (channel.equals(IMPORT_STARTED)) {
            this.eventPublisher.publish((Object)new RemoteImportStartedEvent());
        } else if (channel.equals(IMPORT_FINISHED)) {
            this.eventPublisher.publish((Object)new RemoteImportCompletedEvent(message));
        }
    }
}

