/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.annotations.Internal;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.group.UsersToApplicationsSeatingHelper;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseCountService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public class CreateUserApplicationHelper {
    private final ApplicationRoleManager applicationRoleManager;
    private final I18nHelper i18nHelper;
    private final BaseUrl baseUrl;
    private final GlobalPermissionManager globalPermissionManager;
    private final LicenseCountService licenseCountService;
    private final FeatureManager featureManager;
    private final JiraLicenseManager jiraLicenseManager;
    private final UsersToApplicationsSeatingHelper usersToApplicationsSeatingHelper;
    private final UserManager userManager;

    public CreateUserApplicationHelper(ApplicationRoleManager applicationRoleManager, I18nHelper i18nHelper, BaseUrl baseUrl, GlobalPermissionManager globalPermissionManager, LicenseCountService licenseCountService, FeatureManager featureManager, JiraLicenseManager jiraLicenseManager, UsersToApplicationsSeatingHelper usersToApplicationsSeatingHelper, UserManager userManager) {
        this.applicationRoleManager = applicationRoleManager;
        this.i18nHelper = i18nHelper;
        this.baseUrl = baseUrl;
        this.usersToApplicationsSeatingHelper = usersToApplicationsSeatingHelper;
        this.userManager = userManager;
        this.globalPermissionManager = globalPermissionManager;
        this.licenseCountService = licenseCountService;
        this.featureManager = featureManager;
        this.jiraLicenseManager = jiraLicenseManager;
    }

    public boolean isSingleApplicationInstance() {
        return this.applicationRoleManager.getRoles().size() == 1;
    }

    @Nonnull
    public List<ApplicationSelection> getApplicationsForSelection() {
        return this.getApplicationsForSelection(Collections.emptySet());
    }

    @Nonnull
    public List<ApplicationSelection> getApplicationsForSelection(@Nonnull Set<ApplicationKey> selectedApplicationKeys) {
        Assertions.notNull((String)"selectedApplicationKeys", selectedApplicationKeys);
        if (!this.applicationRoleManager.rolesEnabled()) {
            return ImmutableList.of();
        }
        HashSet applicationSelection = Sets.newHashSet();
        Set roles = this.applicationRoleManager.getRoles();
        Option coreRole = this.applicationRoleManager.getRole(ApplicationKeys.CORE);
        for (ApplicationRole role : roles) {
            String displayName = coreRole.isDefined() && !role.getKey().equals((Object)ApplicationKeys.CORE) ? this.i18nHelper.getText("admin.adduser.application.selection.name.includes.core", role.getName(), ((ApplicationRole)coreRole.get()).getName()) : this.i18nHelper.getText("admin.adduser.application.selection.name.without.core", role.getName());
            Option<String> errorMessage = this.validateRole(role, EnumSet.allOf(ValidationScope.class), ValidationResult.MESSAGE);
            ApplicationKey applicationKey = role.getKey();
            boolean selected = selectedApplicationKeys.contains(applicationKey);
            applicationSelection.add(new ApplicationSelection(applicationKey, displayName, (String)errorMessage.getOrNull(), errorMessage.isEmpty(), selected));
        }
        return Ordering.natural().sortedCopy((Iterable)applicationSelection);
    }

    @Nonnull
    public Collection<String> validateDefaultApplications(EnumSet<ValidationScope> validationScope, Optional<Long> directoryId) {
        return this.validateApplicationKeys(directoryId, this.applicationRoleManager.getDefaultApplicationKeys(), validationScope);
    }

    @Nonnull
    public Collection<String> validateApplicationKeys(@Nonnull Optional<Long> directoryId, @Nonnull Set<ApplicationKey> applicationKeys) {
        return this.validateApplicationKeys(directoryId, applicationKeys, EnumSet.allOf(ValidationScope.class));
    }

    @Nonnull
    public Collection<String> validateApplicationKeys(@Nonnull Optional<Long> directoryId, @Nonnull Set<ApplicationKey> applicationKeys, @Nonnull EnumSet<ValidationScope> validationScope) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.applicationRoleManager.rolesEnabled()) {
            return errors;
        }
        Assertions.containsNoNulls((String)"applicationKeys", applicationKeys);
        HashSet applicationRoles = Sets.newHashSet();
        for (ApplicationKey applicationKey : applicationKeys) {
            Option role = this.applicationRoleManager.getRole(applicationKey);
            if (role.isEmpty()) {
                errors.add(this.i18nHelper.getText("admin.errors.user.add.user.application.not.licensed", applicationKey.value()));
                continue;
            }
            applicationRoles.add(role.get());
        }
        Long directoryOrDefault = directoryId.orElseGet(() -> this.userManager.getDefaultCreateDirectory().map(Directory::getId).orElse(null));
        if (directoryOrDefault == null) {
            errors.add(this.i18nHelper.getText("admin.errors.no.writable.directory"));
            return ImmutableList.copyOf(errors);
        }
        Set<ApplicationRole> applicationsEffectivelyGranted = this.usersToApplicationsSeatingHelper.findEffectiveApplications(directoryOrDefault, applicationRoles);
        if (validationScope.contains((Object)ValidationScope.ACCESS) && !applicationsEffectivelyGranted.containsAll(applicationRoles)) {
            errors.add(this.i18nHelper.getText("admin.errors.user.add.user.application.access.effectively.not.granted"));
            return ImmutableList.copyOf(errors);
        }
        for (ApplicationRole applicationRole : applicationsEffectivelyGranted) {
            Option<String> message = this.validateRole(applicationRole, validationScope, ValidationResult.MARKUP);
            if (!message.isDefined()) continue;
            errors.add((String)message.get());
        }
        return ImmutableList.copyOf(errors);
    }

    public Set<Group> getDefaultGroupsForNewUser(Set<ApplicationKey> applicationKeys) {
        if (!this.applicationRoleManager.rolesEnabled()) {
            if (!this.featureManager.isOnDemand()) {
                int activeUsers = this.licenseCountService.totalBillableUsers();
                int maxUsers = ((LicenseDetails)Iterables.first((Iterable)this.jiraLicenseManager.getLicenses()).get()).getJiraLicense().getMaximumNumberOfUsers();
                if (maxUsers != -1 && activeUsers >= maxUsers) {
                    return ImmutableSet.of();
                }
            }
            HashSet useGroups = new HashSet(this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.USE));
            useGroups.removeAll(this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.ADMINISTER));
            useGroups.removeAll(this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.SYSTEM_ADMIN));
            return ImmutableSet.copyOf(Collections.unmodifiableSet(useGroups));
        }
        return (Set)applicationKeys.stream().filter(appKey -> this.applicationRoleManager.hasSeatsAvailable(appKey, 1)).flatMap(appKey -> this.applicationRoleManager.getDefaultGroups(appKey).stream()).collect(CollectorsUtil.toImmutableSet());
    }

    @Nonnull
    private Option<String> validateRole(@Nonnull ApplicationRole role, @Nonnull EnumSet<ValidationScope> validationScope, @Nonnull ValidationResult validationResult) {
        Option result = Option.none();
        if (validationScope.contains((Object)ValidationScope.SEATS)) {
            result = result.orElse(this.validateRoleSeats(role, validationResult));
        }
        if (result.isEmpty() && validationScope.contains((Object)ValidationScope.ACCESS)) {
            result = result.orElse(this.validateRoleAccess(role, validationResult));
        }
        return result;
    }

    private Option<String> validateRoleSeats(@Nonnull ApplicationRole role, ValidationResult validationResult) {
        if (!this.applicationRoleManager.hasSeatsAvailable(role.getKey(), 1)) {
            switch (validationResult) {
                case MESSAGE: {
                    return Option.some((Object)this.getApplicationAccessLink("admin.errors.user.add.user.application.license.limit.reached"));
                }
                case MARKUP: {
                    return Option.some((Object)this.i18nHelper.getText("admin.errors.user.add.user.application.license.limit.reached.for.application", role.getName()));
                }
            }
        }
        return Option.none();
    }

    private Option<String> validateRoleAccess(@Nonnull ApplicationRole role, ValidationResult validationResult) {
        if (role.getDefaultGroups().isEmpty()) {
            switch (validationResult) {
                case MESSAGE: {
                    return Option.some((Object)this.getApplicationAccessLink("admin.errors.user.add.user.application.no.default.group"));
                }
                case MARKUP: {
                    return Option.some((Object)this.i18nHelper.getText("admin.errors.user.add.user.application.no.default.group.for.application", role.getName()));
                }
            }
        }
        return Option.none();
    }

    private String getApplicationAccessLink(String key) {
        String start = String.format("<a href=\"%s\">", this.baseUrl.getBaseUrl() + "/secure/admin/ApplicationAccess.jspa");
        return this.i18nHelper.getText(key, start, "</a>");
    }

    public static final class ApplicationSelection
    implements Comparable<ApplicationSelection> {
        private final ApplicationKey key;
        private final String displayName;
        private final String message;
        private final boolean selectable;
        private final boolean selected;

        ApplicationSelection(@Nonnull ApplicationKey key, @Nonnull String displayName, @Nullable String message, boolean selectable, boolean selected) {
            this.key = key;
            this.displayName = displayName;
            this.message = message;
            this.selectable = selectable;
            this.selected = selected;
        }

        public String getKey() {
            return this.key.value();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ApplicationSelection)) {
                return false;
            }
            ApplicationSelection that = (ApplicationSelection)o;
            if (this.selectable != that.selectable) {
                return false;
            }
            if (this.selected != that.selected) {
                return false;
            }
            if (!this.displayName.equals(that.displayName)) {
                return false;
            }
            if (!this.key.equals((Object)that.key)) {
                return false;
            }
            return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.displayName.hashCode();
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            result = 31 * result + (this.selectable ? 1 : 0);
            result = 31 * result + (this.selected ? 1 : 0);
            return result;
        }

        @Override
        public int compareTo(@Nullable ApplicationSelection other) {
            if (this == other) {
                return 0;
            }
            if (other == null) {
                return -1;
            }
            if (this.key.equals((Object)other.key)) {
                return this.compareDisplayName(other);
            }
            if (ApplicationKeys.CORE.equals((Object)this.key)) {
                return 1;
            }
            if (ApplicationKeys.CORE.equals((Object)other.key)) {
                return -1;
            }
            return this.compareDisplayName(other);
        }

        private int compareDisplayName(ApplicationSelection other) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.displayName, other.displayName);
        }

        public String toString() {
            return "ApplicationSelection{key='" + this.key + '\'' + ", displayName='" + this.displayName + '\'' + ", message='" + this.message + '\'' + ", selectable=" + this.selectable + ", selected=" + this.selected + '}';
        }
    }

    public static enum ValidationScope {
        ACCESS,
        SEATS;

    }

    private static enum ValidationResult {
        MESSAGE,
        MARKUP;

    }
}

