/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.security.login;

import com.atlassian.jira.bc.security.login.LoginInfo;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class LoginInfoImpl
implements LoginInfo {
    private final Long lastLoginTime;
    private final Long previousLoginTime;
    private final Long loginCount;
    private final Long currentFailedLoginCount;
    private final Long totalFailedLoginCount;
    private final Long lastFailedLoginTime;
    private final boolean elevatedSecurityCheckRequired;
    private final Long maxAuthenticationAttemptsAllowed;

    private LoginInfoImpl(Builder builder) {
        this.lastLoginTime = builder.getLastLoginTime();
        this.previousLoginTime = builder.getPreviousLoginTime();
        this.lastFailedLoginTime = builder.getLastFailedLoginTime();
        this.loginCount = builder.getLoginCount();
        this.currentFailedLoginCount = builder.getCurrentFailedLoginCount();
        this.totalFailedLoginCount = builder.getTotalFailedLoginCount();
        this.maxAuthenticationAttemptsAllowed = builder.getMaxAuthenticationAttemptsAllowed();
        this.elevatedSecurityCheckRequired = builder.isElevatedSecurityCheckRequired();
    }

    public Long getMaxAuthenticationAttemptsAllowed() {
        return this.maxAuthenticationAttemptsAllowed;
    }

    public Long getLastLoginTime() {
        return this.lastLoginTime;
    }

    public Long getPreviousLoginTime() {
        return this.previousLoginTime;
    }

    public Long getLoginCount() {
        return this.loginCount;
    }

    public Long getCurrentFailedLoginCount() {
        return this.currentFailedLoginCount;
    }

    public Long getTotalFailedLoginCount() {
        return this.totalFailedLoginCount;
    }

    public Long getLastFailedLoginTime() {
        return this.lastFailedLoginTime;
    }

    public boolean isElevatedSecurityCheckRequired() {
        return this.elevatedSecurityCheckRequired;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginInfoImpl loginInfo = (LoginInfoImpl)o;
        if (this.elevatedSecurityCheckRequired != loginInfo.elevatedSecurityCheckRequired) {
            return false;
        }
        if (this.currentFailedLoginCount != null ? !this.currentFailedLoginCount.equals(loginInfo.currentFailedLoginCount) : loginInfo.currentFailedLoginCount != null) {
            return false;
        }
        if (this.lastFailedLoginTime != null ? !this.lastFailedLoginTime.equals(loginInfo.lastFailedLoginTime) : loginInfo.lastFailedLoginTime != null) {
            return false;
        }
        if (this.lastLoginTime != null ? !this.lastLoginTime.equals(loginInfo.lastLoginTime) : loginInfo.lastLoginTime != null) {
            return false;
        }
        if (this.loginCount != null ? !this.loginCount.equals(loginInfo.loginCount) : loginInfo.loginCount != null) {
            return false;
        }
        if (this.maxAuthenticationAttemptsAllowed != null ? !this.maxAuthenticationAttemptsAllowed.equals(loginInfo.maxAuthenticationAttemptsAllowed) : loginInfo.maxAuthenticationAttemptsAllowed != null) {
            return false;
        }
        if (this.previousLoginTime != null ? !this.previousLoginTime.equals(loginInfo.previousLoginTime) : loginInfo.previousLoginTime != null) {
            return false;
        }
        return !(this.totalFailedLoginCount != null ? !this.totalFailedLoginCount.equals(loginInfo.totalFailedLoginCount) : loginInfo.totalFailedLoginCount != null);
    }

    public int hashCode() {
        int result = this.lastLoginTime != null ? this.lastLoginTime.hashCode() : 0;
        result = 31 * result + (this.previousLoginTime != null ? this.previousLoginTime.hashCode() : 0);
        result = 31 * result + (this.loginCount != null ? this.loginCount.hashCode() : 0);
        result = 31 * result + (this.currentFailedLoginCount != null ? this.currentFailedLoginCount.hashCode() : 0);
        result = 31 * result + (this.totalFailedLoginCount != null ? this.totalFailedLoginCount.hashCode() : 0);
        result = 31 * result + (this.lastFailedLoginTime != null ? this.lastFailedLoginTime.hashCode() : 0);
        result = 31 * result + (this.elevatedSecurityCheckRequired ? 1 : 0);
        result = 31 * result + (this.maxAuthenticationAttemptsAllowed != null ? this.maxAuthenticationAttemptsAllowed.hashCode() : 0);
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LoginInfo info) {
        return new Builder(info);
    }

    public static class Builder {
        private Long lastLoginTime;
        private Long previousLoginTime;
        private Long loginCount;
        private Long currentFailedLoginCount;
        private Long totalFailedLoginCount;
        private Long lastFailedLoginTime;
        private boolean elevatedSecurityCheckRequired;
        private Long maxAuthenticationAttemptsAllowed;

        private Builder() {
        }

        private Builder(LoginInfo info) {
            this.lastLoginTime = info.getLastLoginTime();
            this.previousLoginTime = info.getPreviousLoginTime();
            this.loginCount = info.getLoginCount();
            this.currentFailedLoginCount = info.getCurrentFailedLoginCount();
            this.totalFailedLoginCount = info.getTotalFailedLoginCount();
            this.lastFailedLoginTime = info.getLastFailedLoginTime();
            this.elevatedSecurityCheckRequired = info.isElevatedSecurityCheckRequired();
            this.maxAuthenticationAttemptsAllowed = info.getMaxAuthenticationAttemptsAllowed();
        }

        public Long getLastLoginTime() {
            return this.lastLoginTime;
        }

        public Long getPreviousLoginTime() {
            return this.previousLoginTime;
        }

        public Long getLoginCount() {
            return this.loginCount;
        }

        public Long getCurrentFailedLoginCount() {
            return this.currentFailedLoginCount;
        }

        public Long getTotalFailedLoginCount() {
            return this.totalFailedLoginCount;
        }

        public Long getLastFailedLoginTime() {
            return this.lastFailedLoginTime;
        }

        public boolean isElevatedSecurityCheckRequired() {
            return this.elevatedSecurityCheckRequired;
        }

        public Long getMaxAuthenticationAttemptsAllowed() {
            return this.maxAuthenticationAttemptsAllowed;
        }

        public Builder setLastLoginTime(Long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
            return this;
        }

        public Builder setPreviousLoginTime(Long previousLoginTime) {
            this.previousLoginTime = previousLoginTime;
            return this;
        }

        public Builder setLoginCount(Long loginCount) {
            this.loginCount = loginCount;
            return this;
        }

        public Builder setCurrentFailedLoginCount(Long currentFailedLoginCount) {
            this.currentFailedLoginCount = currentFailedLoginCount;
            return this;
        }

        public Builder setTotalFailedLoginCount(Long totalFailedLoginCount) {
            this.totalFailedLoginCount = totalFailedLoginCount;
            return this;
        }

        public Builder setLastFailedLoginTime(Long lastFailedLoginTime) {
            this.lastFailedLoginTime = lastFailedLoginTime;
            return this;
        }

        public Builder setElevatedSecurityCheckRequired(boolean elevatedSecurityCheckRequired) {
            this.elevatedSecurityCheckRequired = elevatedSecurityCheckRequired;
            return this;
        }

        public Builder setMaxAuthenticationAttemptsAllowed(Long maxAuthenticationAttemptsAllowed) {
            this.maxAuthenticationAttemptsAllowed = maxAuthenticationAttemptsAllowed;
            return this;
        }

        public Builder failedAt(long now) {
            this.currentFailedLoginCount = Builder.increment(this.currentFailedLoginCount);
            this.totalFailedLoginCount = Builder.increment(this.totalFailedLoginCount);
            this.lastFailedLoginTime = now;
            return this;
        }

        public Builder succeededAt(long now) {
            this.lastFailedLoginTime = 0L;
            this.currentFailedLoginCount = 0L;
            this.loginCount = Builder.increment(this.loginCount);
            if (this.lastLoginTime != null) {
                this.previousLoginTime = this.lastLoginTime;
            }
            this.lastLoginTime = now;
            return this;
        }

        public LoginInfo build() {
            return new LoginInfoImpl(this);
        }

        private static Long increment(Long value) {
            if (value == null || value < 0L) {
                return 1L;
            }
            return value + 1L;
        }
    }
}

