/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.property;

import com.atlassian.fugue.Function2;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.EntityWithKeyPropertyHelper;
import com.atlassian.jira.event.project.property.ProjectPropertyDeletedEvent;
import com.atlassian.jira.event.project.property.ProjectPropertySetEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;

public class ProjectPropertyHelper
implements EntityWithKeyPropertyHelper<Project> {
    private final DeletePropertyEventFunction deletePropertyEventFunction;
    private final I18nHelper i18n;
    private final ProjectByIdFunction projectByIdFunction;
    private final ProjectByKeyFunction projectByKeyFunction;
    private final HasEditPermissionFunction editPermissionFunction;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final HasViewPermissionFunction viewPermissionFunction;
    private final SetPropertyEventFunction setPropertyEventFunction;

    public ProjectPropertyHelper(I18nHelper i18n, ProjectManager projectManager, PermissionManager permissionManager) {
        this.i18n = i18n;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.deletePropertyEventFunction = new DeletePropertyEventFunction();
        this.projectByIdFunction = new ProjectByIdFunction();
        this.projectByKeyFunction = new ProjectByKeyFunction();
        this.editPermissionFunction = new HasEditPermissionFunction();
        this.viewPermissionFunction = new HasViewPermissionFunction();
        this.setPropertyEventFunction = new SetPropertyEventFunction();
    }

    public Function<String, Option<Project>> getEntityByKeyFunction() {
        return this.projectByKeyFunction;
    }

    public EntityPropertyHelper.CheckPermissionFunction<Project> hasEditPermissionFunction() {
        return this.editPermissionFunction;
    }

    public EntityPropertyHelper.CheckPermissionFunction<Project> hasReadPermissionFunction() {
        return this.viewPermissionFunction;
    }

    public Function<Long, Option<Project>> getEntityByIdFunction() {
        return this.projectByIdFunction;
    }

    public Function2<ApplicationUser, EntityProperty, ProjectPropertySetEvent> createSetPropertyEventFunction() {
        return this.setPropertyEventFunction;
    }

    public Function2<ApplicationUser, EntityProperty, ProjectPropertyDeletedEvent> createDeletePropertyEventFunction() {
        return this.deletePropertyEventFunction;
    }

    public EntityPropertyType getEntityPropertyType() {
        return EntityPropertyType.PROJECT_PROPERTY;
    }

    private ErrorCollection checkProjectPermission(ApplicationUser user, Project project, ProjectAction projectAction) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!projectAction.hasPermission(this.permissionManager, user, project)) {
            ErrorCollection.Reason reason = user == null ? ErrorCollection.Reason.NOT_LOGGED_IN : ErrorCollection.Reason.FORBIDDEN;
            errorCollection.addErrorMessage(this.i18n.getText(projectAction.getErrorKey()), reason);
        }
        return errorCollection;
    }

    private class SetPropertyEventFunction
    implements Function2<ApplicationUser, EntityProperty, ProjectPropertySetEvent> {
        private SetPropertyEventFunction() {
        }

        public ProjectPropertySetEvent apply(ApplicationUser user, EntityProperty entityProperty) {
            return new ProjectPropertySetEvent(entityProperty, user);
        }
    }

    private class HasViewPermissionFunction
    implements EntityPropertyHelper.CheckPermissionFunction<Project> {
        private HasViewPermissionFunction() {
        }

        public ErrorCollection apply(ApplicationUser user, Project project) {
            return ProjectPropertyHelper.this.checkProjectPermission(user, project, ProjectAction.VIEW_PROJECT);
        }
    }

    private class HasEditPermissionFunction
    implements EntityPropertyHelper.CheckPermissionFunction<Project> {
        private HasEditPermissionFunction() {
        }

        public ErrorCollection apply(ApplicationUser user, Project project) {
            return ProjectPropertyHelper.this.checkProjectPermission(user, project, ProjectAction.EDIT_PROJECT_CONFIG);
        }
    }

    private class ProjectByIdFunction
    implements Function<Long, Option<Project>> {
        private ProjectByIdFunction() {
        }

        public Option<Project> apply(Long projectId) {
            return Option.option((Object)ProjectPropertyHelper.this.projectManager.getProjectObj(projectId));
        }
    }

    private class ProjectByKeyFunction
    implements Function<String, Option<Project>> {
        private ProjectByKeyFunction() {
        }

        public Option<Project> apply(String projectKey) {
            return Option.option((Object)ProjectPropertyHelper.this.projectManager.getProjectObjByKey(projectKey));
        }
    }

    private class DeletePropertyEventFunction
    implements Function2<ApplicationUser, EntityProperty, ProjectPropertyDeletedEvent> {
        private DeletePropertyEventFunction() {
        }

        public ProjectPropertyDeletedEvent apply(ApplicationUser user, EntityProperty entityProperty) {
            return new ProjectPropertyDeletedEvent(entityProperty, user);
        }
    }
}

