/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.index;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.project.index.ProjectIndexTaskContext;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.IssueIndexHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.BackgroundIndexListener;
import com.atlassian.jira.issue.index.IndexReconciler;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.statistics.util.FieldableDocumentHitCollector;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.search.Collector;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;

class ReIndexProjectIndexerCommand
implements Callable<IndexCommandResult>,
ProvidesTaskProgress {
    private final Project project;
    private final OfBizDelegator delegator;
    private final IssueIndexer issueIndexer;
    private final TaskManager taskManager;
    private final SearchProvider searchProvider;
    private final IssueManager issueManager;
    private final EventPublisher eventPublisher;
    private static final int BATCH_SIZE_FOR_PROJECT = 100;
    private final IssueBatcherFactory issueBatcherFactory;
    private final Logger log;
    private final I18nHelper i18nHelper;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final ClusterManager clusterManager;
    private volatile TaskProgressSink taskProgressSink;

    public ReIndexProjectIndexerCommand(Project project, OfBizDelegator delegator, IssueIndexer issueIndexer, TaskManager taskManager, SearchProvider searchProvider, IssueManager issueManager, EventPublisher eventPublisher, IssueBatcherFactory issueBatcherFactory, Logger log, I18nHelper i18nHelper, I18nHelper.BeanFactory i18nBeanFactory, ClusterManager clusterManager) {
        this.issueIndexer = issueIndexer;
        this.taskManager = taskManager;
        this.delegator = delegator;
        this.project = project;
        this.searchProvider = searchProvider;
        this.issueManager = issueManager;
        this.eventPublisher = eventPublisher;
        this.issueBatcherFactory = issueBatcherFactory;
        this.log = log;
        this.i18nHelper = i18nHelper;
        this.i18nBeanFactory = i18nBeanFactory;
        this.clusterManager = clusterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexCommandResult call() {
        String johnsonMessage = this.i18nBeanFactory.getInstance((ApplicationUser)null).getText("admin.reindex.in.progress.johnson.summary");
        Event appEvent = new Event(EventType.get((String)"reindex"), johnsonMessage, EventLevel.get((String)"warning"));
        try {
            Context context = Contexts.percentageReporter((Sized)new Sized(){

                public int size() {
                    return (int)ReIndexProjectIndexerCommand.this.delegator.getCountByAnd("Issue", (Map)ImmutableMap.of((Object)"project", (Object)ReIndexProjectIndexerCommand.this.project.getId()));
                }

                public boolean isEmpty() {
                    return this.size() == 0;
                }
            }, (TaskProgressSink)this.taskProgressSink, (I18nHelper)this.i18nHelper, (Logger)this.log, (Event)appEvent);
            this.log.info((Object)"Re-indexing started");
            Assertions.notNull((String)"context", (Object)context);
            context.setName("Issue");
            this.log.info((Object)String.format("Reindexing issues in project %s", this.project.getName()));
            long startTime = System.currentTimeMillis();
            if (!this.reindexAllProjectIssues(context)) {
                IndexCommandResult indexCommandResult = new IndexCommandResult(-1L);
                return indexCommandResult;
            }
            long totalTime = System.currentTimeMillis() - startTime;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Reindex took : " + totalTime + "ms"));
            }
            IndexCommandResult indexCommandResult = new IndexCommandResult(totalTime);
            return indexCommandResult;
        }
        finally {
            this.log.info((Object)"Re-indexing finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reindexAllProjectIssues(Context context) {
        TaskDescriptor currentTaskDescriptor = this.taskManager.getLiveTask(new ProjectIndexTaskContext(this.project, this.clusterManager.getNodeId()));
        IssueIndexHelper issueIndexHelper = new IssueIndexHelper(this.issueManager, this.issueIndexer, this.getIssueFactory());
        AccumulatingResultBuilder resultBuilder = new AccumulatingResultBuilder();
        BackgroundIndexListener backgroundIndexListener = new BackgroundIndexListener();
        this.eventPublisher.register((Object)backgroundIndexListener);
        try {
            long[] indexedIssues = this.getProjectIssuesFromLucene();
            IndexReconciler reconciler = new IndexReconciler(indexedIssues);
            try {
                EntityExpr where = new EntityExpr("project", EntityOperator.EQUALS, (Object)this.project.getId());
                IssuesBatcher batcher = this.issueBatcherFactory.getBatcher((EntityCondition)where, reconciler, 100);
                for (IssuesIterable batchOfIssues : batcher) {
                    if (currentTaskDescriptor.isCancelled()) {
                        throw new InterruptedException();
                    }
                    resultBuilder.add(this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batchOfIssues, context, false, true, false));
                }
                resultBuilder.toResult().await();
            }
            finally {
                this.eventPublisher.unregister((Object)backgroundIndexListener);
                issueIndexHelper.fixupConcurrentlyIndexedIssues(context, resultBuilder, backgroundIndexListener, IssueIndexingParams.INDEX_ALL);
            }
            if (currentTaskDescriptor.isCancelled()) {
                throw new InterruptedException();
            }
            issueIndexHelper.fixupIndexCorruptions(resultBuilder, reconciler);
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    private long[] getProjectIssuesFromLucene() throws SearchException {
        ProjectIssueCollector issueCollector = new ProjectIssueCollector();
        JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().project(new Long[]{this.project.getId()});
        this.searchProvider.searchOverrideSecurity(builder.buildQuery(), (ApplicationUser)null, (Collector)issueCollector);
        return issueCollector.getIssueIds();
    }

    public I18nHelper getI18nHelper() {
        return this.i18nHelper;
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }

    IssueFactory getIssueFactory() {
        return (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
    }

    private static class ProjectIssueCollector
    extends FieldableDocumentHitCollector {
        long[] issueIds = new long[1000];
        private int i = 0;
        private String issueIdFieldName = SystemSearchConstants.forIssueId().getIndexField();
        private FieldSelector selector = new FieldSelector(){

            public FieldSelectorResult accept(String fieldName) {
                return fieldName.equals(issueIdFieldName) ? FieldSelectorResult.LOAD_AND_BREAK : FieldSelectorResult.NO_LOAD;
            }
        };

        private ProjectIssueCollector() {
        }

        protected FieldSelector getFieldSelector() {
            return this.selector;
        }

        public void collect(Document doc) {
            String issueId = doc.get(this.issueIdFieldName);
            this.issueIds = this.ensureCapacity(this.issueIds, this.i);
            this.issueIds[this.i] = Long.parseLong(issueId);
            ++this.i;
        }

        private long[] ensureCapacity(long[] issueIds, int i) {
            if (issueIds.length <= i) {
                int newSize = Math.max(i, issueIds.length + issueIds.length / 10);
                return Arrays.copyOf(issueIds, newSize);
            }
            return issueIds;
        }

        public long[] getIssueIds() {
            return Arrays.copyOf(this.issueIds, this.i);
        }
    }
}

