/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport.ha;

import com.atlassian.jira.bc.dataimport.ha.ClusterImportService;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.NotClusteredException;
import com.atlassian.jira.index.ha.IndexCopyService;

public class DefaultClusterImportService
implements ClusterImportService {
    private final NodeStateManager nodeStateManager;
    private final IndexCopyService indexCopyService;

    public DefaultClusterImportService(NodeStateManager nodeStateManager, IndexCopyService indexCopyService) {
        this.nodeStateManager = nodeStateManager;
        this.indexCopyService = indexCopyService;
    }

    @Override
    public void prepareImport() {
        this.indexCopyService.backupIndex("ANY");
    }

    @Override
    public void doImport(String fileName) {
        try {
            this.nodeStateManager.quiesce();
            this.indexCopyService.restoreIndex(fileName);
            this.nodeStateManager.restart();
        }
        catch (NotClusteredException e) {
            throw new RuntimeException(e);
        }
    }
}

