/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.model.querydsl.UpgradeHistoryDTO;
import com.atlassian.jira.upgrade.DowngradeException;
import com.atlassian.jira.upgrade.DowngradeTask;
import com.atlassian.jira.upgrade.DowngradeTaskFileParser;
import com.atlassian.jira.upgrade.MissingDowngradeTaskException;
import com.atlassian.jira.upgrade.ReindexRequirement;
import com.atlassian.jira.util.BuildUtilsInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DowngradeUtil {
    private static final Logger log = LoggerFactory.getLogger(DowngradeUtil.class);
    private static final String AP_KEY_REINDEX_REQUIREMENT = "jira.downgrade.ReindexRequirement";
    private static final String STATUS_COMPLETE = "complete";
    private static final String STATUS_PENDING = "pending";
    private static final String DOWNGRADE_FILENAME = "downgrades.xml";

    public static boolean canDowngrade(List<UpgradeHistoryDTO> upgradeHistoryItems, BuildUtilsInfo buildUtilsInfo) {
        try {
            List<Integer> downgradeTaskNumbers = DowngradeUtil.findDowngradeTasksToRun(upgradeHistoryItems, buildUtilsInfo);
            Map<Integer, DowngradeTask> downgradeTaskMap = DowngradeUtil.loadDowngradeTasks();
            DowngradeUtil.verifyTasksExist(downgradeTaskNumbers, downgradeTaskMap);
            return true;
        }
        catch (DowngradeException ex) {
            log.error("Downgrade cannot proceed: " + ex.getMessage());
            return false;
        }
    }

    @Nonnull
    public static List<Integer> findDowngradeTasksToRun(List<UpgradeHistoryDTO> upgradeHistoryItems, BuildUtilsInfo buildUtilsInfo) throws DowngradeException {
        int applicationBuildNumber = buildUtilsInfo.getApplicationBuildNumber();
        HashSet<Integer> uniqueBuildNumbers = new HashSet<Integer>();
        boolean oldUpgradeTaskFound = false;
        for (UpgradeHistoryDTO upgradeHistoryItem : upgradeHistoryItems) {
            int buildNumber = DowngradeUtil.parseBuildNumber(upgradeHistoryItem.getTargetbuild());
            if (buildNumber > applicationBuildNumber) {
                if (!DowngradeUtil.requiresDowngradeTask(upgradeHistoryItem)) continue;
                uniqueBuildNumbers.add(buildNumber);
                continue;
            }
            oldUpgradeTaskFound = true;
        }
        if (!oldUpgradeTaskFound) {
            throw new DowngradeException("Unable to downgrade data to build number " + applicationBuildNumber + " because it does not have sufficient upgrade task history.");
        }
        ArrayList<Integer> downgradeTasks = new ArrayList<Integer>(uniqueBuildNumbers);
        Collections.sort(downgradeTasks);
        Collections.reverse(downgradeTasks);
        return downgradeTasks;
    }

    private static boolean requiresDowngradeTask(UpgradeHistoryDTO upgradeHistoryItem) throws DowngradeException {
        if ("N".equals(upgradeHistoryItem.getDowngradetaskrequired())) {
            return false;
        }
        if (STATUS_COMPLETE.equals(upgradeHistoryItem.getStatus())) {
            return true;
        }
        if (STATUS_PENDING.equals(upgradeHistoryItem.getStatus())) {
            return false;
        }
        throw new DowngradeException("Unable to downgrade data because upgrade " + upgradeHistoryItem.getTargetbuild() + " is in an unknown state '" + upgradeHistoryItem.getStatus() + "'.");
    }

    public static Map<Integer, DowngradeTask> loadDowngradeTasks() throws DowngradeException {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)DOWNGRADE_FILENAME, DowngradeUtil.class);
        try {
            Collection<String> classNames = new DowngradeTaskFileParser().parse(is);
            HashMap<Integer, DowngradeTask> downgradeTaskMap = new HashMap<Integer, DowngradeTask>(classNames.size());
            for (String className : classNames) {
                DowngradeTask downgradeTask = DowngradeUtil.constructNewInstance(className);
                downgradeTaskMap.put(downgradeTask.getBuildNumber(), downgradeTask);
            }
            return downgradeTaskMap;
        }
        catch (Exception ex) {
            log.error("Unable to parse the Downgrade config file downgrades.xml.", (Throwable)ex);
            throw new DowngradeException("An unexpected error occurred while parsing the Downgrade config file.");
        }
    }

    private static DowngradeTask constructNewInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(className);
        try {
            return (DowngradeTask)clazz.newInstance();
        }
        catch (InstantiationException ex) {
            log.error("Unable to construct class '" + className + "' - Downgrade Tasks must provide a no arg constructor.");
            throw ex;
        }
    }

    private static int parseBuildNumber(String targetbuild) throws DowngradeException {
        if (targetbuild == null) {
            return -1;
        }
        try {
            return Integer.parseInt(targetbuild);
        }
        catch (NumberFormatException e) {
            throw new DowngradeException("Unable to parse build number '" + targetbuild + "' in upgrade history.");
        }
    }

    public static void verifyTasksExist(List<Integer> downgradeTaskNumbers, Map<Integer, DowngradeTask> downgradeTaskMap) throws MissingDowngradeTaskException {
        for (Integer downgradeTaskNumber : downgradeTaskNumbers) {
            if (downgradeTaskMap.containsKey(downgradeTaskNumber)) continue;
            throw new MissingDowngradeTaskException("Cannot downgrade data - missing downgrade task " + downgradeTaskNumber);
        }
    }

    @Nonnull
    public static ReindexRequirement getReindexRequirement(ApplicationProperties applicationProperties) {
        String strValue = applicationProperties.getString(AP_KEY_REINDEX_REQUIREMENT);
        return strValue == null ? ReindexRequirement.NONE : ReindexRequirement.valueOf(strValue);
    }

    public static void setReindexRequirement(ApplicationProperties applicationProperties, ReindexRequirement reindexRequirement) {
        applicationProperties.setString(AP_KEY_REINDEX_REQUIREMENT, reindexRequirement.name());
    }
}

