/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.admin;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NavigableFieldListValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(NavigableFieldListValidator.class);
    FieldManager fieldManager;

    public NavigableFieldListValidator(FieldManager fieldManager) {
        this.fieldManager = fieldManager;
    }

    public NavigableFieldListValidator() {
        this((FieldManager)ComponentAccessor.getComponent(FieldManager.class));
    }

    @Override
    public Validator.Result validate(String value) {
        String[] fields = value.split(",");
        ArrayList<String> badFields = new ArrayList<String>();
        for (String f : fields) {
            String field = f.trim();
            try {
                if (!"".equals(field) && this.fieldManager.getNavigableField(field) != null) continue;
                badFields.add(field);
                log.debug("Couldn't find requested navigable field '" + field + "'");
            }
            catch (RuntimeException e) {
                badFields.add(field);
                log.debug("Couldn't find requested navigable field '" + field + "'");
            }
        }
        if (badFields.isEmpty()) {
            return new Success(value);
        }
        String mesg = "The following fields are invalid: " + StringUtils.createCommaSeperatedString(badFields);
        return new Failure(mesg, TextUtils.htmlEncode((String)mesg));
    }
}

