/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar.types;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImageDataProvider;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.SystemAndCustomAvatars;
import com.atlassian.jira.avatar.TypeAvatarService;
import com.atlassian.jira.avatar.types.AvatarAccessPolicy;
import com.atlassian.jira.user.ApplicationUser;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class BasicTypedTypeAvatarService
implements TypeAvatarService {
    private final Avatar.Type type;
    private final AvatarManager avatarManager;
    private final AvatarAccessPolicy policy;

    public BasicTypedTypeAvatarService(Avatar.Type type, AvatarManager avatarManager, AvatarAccessPolicy policy) {
        this.type = type;
        this.avatarManager = avatarManager;
        this.policy = policy;
    }

    public final SystemAndCustomAvatars getAvatars(ApplicationUser remoteUser, String owningObjectId) {
        List systemAvatars = this.avatarManager.getAllSystemAvatars(this.type);
        List avatarsForOwner = this.avatarManager.getCustomAvatarsForOwner(this.type, owningObjectId);
        return new SystemAndCustomAvatars(systemAvatars, avatarsForOwner);
    }

    public Avatar getAvatar(ApplicationUser remoteUser, long avatarId) {
        Avatar currentAvatar = this.avatarManager.getById(Long.valueOf(avatarId));
        boolean userCanViewAvatar = currentAvatar != null ? this.policy.userCanViewAvatar(remoteUser, currentAvatar) : false;
        return userCanViewAvatar ? currentAvatar : null;
    }

    public boolean canUserCreateAvatar(ApplicationUser remoteUser, String owningObjectId) {
        return this.policy.userCanCreateAvatarFor(remoteUser, owningObjectId);
    }

    public Avatar createAvatar(ApplicationUser remoteUser, String owningObjectId, AvatarImageDataProvider imageDataProvider) throws IllegalAccessException, IOException {
        if (!this.policy.userCanCreateAvatarFor(remoteUser, owningObjectId)) {
            throw new IllegalAccessException();
        }
        return this.avatarManager.create(this.type, owningObjectId, imageDataProvider);
    }

    @Nonnull
    public Avatar getDefaultAvatar() {
        Long defaultAvatarId = this.avatarManager.getDefaultAvatarId(this.type);
        if (null == defaultAvatarId) {
            throw new NoSuchElementException("No default avatar id for " + this.type);
        }
        Avatar avatar = this.avatarManager.getById(defaultAvatarId);
        if (null == avatar) {
            throw new NoSuchElementException("No default avatar for " + this.type);
        }
        return avatar;
    }
}

