/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar.temporary;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.TemporaryAvatar;
import com.atlassian.jira.avatar.TemporaryAvatars;
import com.atlassian.jira.avatar.TypeAvatarService;
import com.atlassian.jira.avatar.UniversalAvatarsService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.ExecutingHttpRequest;
import javax.servlet.http.HttpSession;

public class TemporaryAvatarsImpl
implements TemporaryAvatars {
    private final UniversalAvatarsService avatars;

    public TemporaryAvatarsImpl(UniversalAvatarsService avatars) {
        this.avatars = avatars;
    }

    public void storeTemporaryAvatar(ApplicationUser remoteUser, TemporaryAvatar avatar, Avatar.Type type, String ownerId) throws IllegalAccessException {
        TypeAvatarService typeAvatars = this.avatars.getAvatars(type);
        if (typeAvatars == null || !typeAvatars.canUserCreateAvatar(remoteUser, ownerId)) {
            throw new IllegalAccessException("User cannot store temporary avatars");
        }
        ExecutingHttpRequest.get().getSession().setAttribute("tempAvatarFile", (Object)avatar);
    }

    public TemporaryAvatar getCurrentTemporaryAvatar() {
        HttpSession session = ExecutingHttpRequest.get().getSession();
        return (TemporaryAvatar)session.getAttribute("tempAvatarFile");
    }

    public void dispose(TemporaryAvatar avatar) {
        avatar.getFile().delete();
        HttpSession session = ExecutingHttpRequest.get().getSession();
        session.removeAttribute("tempAvatarFile");
    }
}

