/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.host.ApplicationAccessFactory;
import com.atlassian.application.host.NotLicensedAccess;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.application.JiraApplicationAccess;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import org.joda.time.DateTime;

public class JiraApplicationAccessFactory
implements ApplicationAccessFactory {
    private final ApplicationRoleManager applicationRoleManager;
    private final UserManager userManager;
    private final JiraLicenseManager manager;

    public JiraApplicationAccessFactory(ApplicationRoleManager applicationRoleManager, UserManager userManager, JiraLicenseManager manager) {
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
        this.manager = (JiraLicenseManager)Assertions.notNull((String)"manager", (Object)manager);
    }

    private static ApplicationAccess createNoLicensedAccess(ApplicationKey key) {
        return new NotLicensedAccess(key, JiraApplicationAccess.URI_MANAGEMENT);
    }

    public ApplicationAccess access(ApplicationKey key, DateTime buildDate) {
        Assertions.notNull((String)"key", (Object)key);
        Assertions.notNull((String)"buildDate", (Object)buildDate);
        Option role = this.applicationRoleManager.getRole(key);
        if (role.isEmpty()) {
            return JiraApplicationAccessFactory.createNoLicensedAccess(key);
        }
        Option licenseFor = this.manager.getLicense(key);
        if (licenseFor.isEmpty()) {
            return JiraApplicationAccessFactory.createNoLicensedAccess(key);
        }
        return new JiraApplicationAccess((ApplicationRole)role.get(), (ApplicationAuthorizationService)ComponentAccessor.getComponent(ApplicationAuthorizationService.class), this.userManager);
    }
}

