/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public interface ApplicationRoleStore {
    @Nonnull
    public ApplicationRoleData get(@Nonnull ApplicationKey var1);

    @Nonnull
    public ApplicationRoleData save(@Nonnull ApplicationRoleData var1);

    public void removeGroup(@Nonnull String var1);

    @Immutable
    public static final class ApplicationRoleData {
        private final Set<String> groups;
        private final Set<String> defaultGroups;
        private final ApplicationKey key;
        private final boolean selectedByDefault;

        public ApplicationRoleData(ApplicationKey key, Iterable<String> groups, Iterable<String> defaultGroups, boolean selectedByDefault) {
            this.key = (ApplicationKey)Assertions.notNull((String)"id", (Object)key);
            this.groups = ImmutableSet.copyOf((Iterable)Assertions.containsNoNulls((String)"groups", groups));
            this.defaultGroups = ImmutableSet.copyOf((Iterable)Assertions.containsNoNulls((String)"defaultGroups", defaultGroups));
            this.selectedByDefault = selectedByDefault;
        }

        public Set<String> getGroups() {
            return this.groups;
        }

        public Set<String> getDefaultGroups() {
            return this.defaultGroups;
        }

        public ApplicationKey getKey() {
            return this.key;
        }

        public boolean isSelectedByDefault() {
            return this.selectedByDefault;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationRoleData that = (ApplicationRoleData)o;
            return Objects.equals(this.selectedByDefault, that.selectedByDefault) && Objects.equals(this.groups, that.groups) && Objects.equals(this.defaultGroups, that.defaultGroups) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.groups, this.defaultGroups, this.key, this.selectedByDefault);
        }
    }
}

