/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.amendment.DeleteEntityAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class SchemePermissionCheck
extends CheckImpl {
    public SchemePermissionCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.scheme.permission.check.desc");
    }

    @Override
    public List preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List correct() throws IntegrityException {
        return this.doCheck(true);
    }

    private List doCheck(boolean correct) throws IntegrityException {
        List amendments = this.getAmendments();
        if (correct) {
            for (Object amendment : amendments) {
                DeleteEntityAmendment createEntityAmendment = (DeleteEntityAmendment)amendment;
                try {
                    this.ofBizDelegator.removeValue(createEntityAmendment.getEntity());
                }
                catch (Exception e) {
                    throw new IntegrityException(e);
                }
            }
        }
        return amendments;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    private List getAmendments() throws IntegrityException {
        ArrayList<DeleteEntityAmendment> amendments = new ArrayList<DeleteEntityAmendment>();
        ArrayList<GenericValue> firstDuplicate = new ArrayList<GenericValue>();
        try (OfBizListIterator listIterator = null;){
            listIterator = this.ofBizDelegator.findListIteratorByCondition("SchemePermissions", null);
            GenericValue genericValue = listIterator.next();
            while (genericValue != null) {
                List schemePermissions = this.ofBizDelegator.findByAnd("SchemePermissions", (Map)FieldMap.build((String)"scheme", (Object)genericValue.getLong("scheme"), (String)"permissionKey", (Object)genericValue.getString("permissionKey"), (String)"type", (Object)genericValue.getString("type"), (String)"parameter", (Object)genericValue.getString("parameter")));
                if (schemePermissions.size() > 1) {
                    List containsDuplicate = EntityUtil.filterByAnd(firstDuplicate, (Map)FieldMap.build((String)"scheme", (Object)genericValue.getLong("scheme"), (String)"permissionKey", (Object)genericValue.getString("permissionKey"), (String)"type", (Object)genericValue.getString("type"), (String)"parameter", (Object)genericValue.getString("parameter")));
                    if (containsDuplicate.isEmpty()) {
                        firstDuplicate.add(genericValue);
                    } else {
                        amendments.add(new DeleteEntityAmendment(2, this.getI18NBean().getText("admin.integrity.check.scheme.permission.check.message"), genericValue));
                    }
                }
                genericValue = listIterator.next();
            }
        }
        return amendments;
    }
}

