/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtilsImpl;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.jira.web.util.InternalServerErrorDataSource;
import com.atlassian.jira.web.util.MetalResourcesManager;
import com.atlassian.jira.web.util.PrettyObjectPrinter;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalServerErrorHelper {
    private static final Logger log = LoggerFactory.getLogger(InternalServerErrorHelper.class);

    public static void render500ResponsePage(HttpServletRequest req, Writer writer) throws IOException {
        try {
            boolean shouldShowFullInfo;
            String id = UUID.randomUUID().toString();
            Logger log = LoggerFactory.getLogger((String)("500ErrorPage." + id));
            ImmutableMap.Builder map = ImmutableMap.builder();
            map.put((Object)"footer", (Object)InternalServerErrorHelper.getFooterContent(req));
            map.put((Object)"helpsteps", InternalServerErrorHelper.prepareHelpSteps(req));
            map.put((Object)"resourcesContent", (Object)MetalResourcesManager.getMetalResources(req.getContextPath()));
            if (!InternalServerErrorHelper.isOnDemand() || InternalServerErrorHelper.isLoggedInAdmin()) {
                map.put((Object)"errorId", (Object)id);
            }
            InternalServerErrorDataSource ds = InternalServerErrorHelper.initializeInternalServerErrorDS(req, log);
            ImmutableMap.Builder technicalDetails = ImmutableMap.builder();
            boolean bl = shouldShowFullInfo = InternalServerErrorHelper.isLoggedInAdmin() || JiraSystemProperties.isDevMode();
            if (shouldShowFullInfo && !Boolean.parseBoolean(req.getParameter("short"))) {
                ds.appendFullMessageData((ImmutableMap.Builder<String, Object>)technicalDetails, InternalServerErrorHelper.isLoggedInSysAdmin() || JiraSystemProperties.isDevMode());
                map.put((Object)"fullInfo", (Object)true);
            } else {
                ds.appendSimpleMessageData((ImmutableMap.Builder<String, Object>)technicalDetails);
                map.put((Object)"fullInfo", (Object)false);
                ds.notForSoy();
            }
            ImmutableMap.Builder rawMapBuilder = ImmutableMap.builder();
            ImmutableMap soyData = ds.appendFullMessageData((ImmutableMap.Builder<String, Object>)rawMapBuilder, true).build();
            PrettyObjectPrinter pop = new PrettyObjectPrinter(soyData);
            log.debug(pop.toString());
            map.put((Object)"technicalDetails", (Object)technicalDetails.build());
            ImmutableMap build = map.build();
            SoyTemplateRenderer renderer = (SoyTemplateRenderer)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
            renderer.render((Appendable)writer, "jira.webresources:jira-errors", "JIRA.Templates.errors.InternalError.page", (Map)build);
        }
        catch (SoyException e) {
            log.error("Cannot render soy template for 500 page", (Throwable)e);
        }
    }

    private static boolean isOnDemand() {
        FeatureManager featureManager = (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
        if (featureManager == null) {
            return true;
        }
        return featureManager.isOnDemand();
    }

    private static boolean isLoggedInAdmin() {
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (user == null) {
            return false;
        }
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        return permissionManager.hasPermission(0, user) || permissionManager.hasPermission(44, user);
    }

    private static boolean isLoggedInSysAdmin() {
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (user == null) {
            return false;
        }
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        return permissionManager.hasPermission(44, user);
    }

    private static String getFooterContent(HttpServletRequest httpRequest) {
        PluginAccessor pluginAccessor = ComponentAccessor.getPluginAccessor();
        if (pluginAccessor == null) {
            return "";
        }
        FooterModuleDescriptor footer = (FooterModuleDescriptor)pluginAccessor.getEnabledPluginModule("jira.footer:standard-footer");
        if (footer == null) {
            return "";
        }
        return ((PluggableFooter)footer.getModule()).getFullFooterHtml(httpRequest);
    }

    private static List<String> prepareHelpSteps(HttpServletRequest req) {
        I18nHelper i18n = InternalServerErrorHelper.getI18nHelper();
        if (InternalServerErrorHelper.isOnDemand()) {
            if (InternalServerErrorHelper.isLoggedInAdmin()) {
                ExternalLinkUtilImpl externalLinkUtil = new ExternalLinkUtilImpl();
                String sac = externalLinkUtil.getProperty("external.link.jira.support.site");
                return ImmutableList.of((Object)i18n.getText("500.raise.an.issue.on.sac", "<a href=\"" + sac + "\">", "</a>"));
            }
            String contactAdministratorsLink = InternalServerErrorHelper.getContactAdministratorLink(req);
            return ImmutableList.of((Object)(contactAdministratorsLink != null ? i18n.getText("500.send.to.your.jira.admin.contact.form", "<a target=\"_blank\" href=\"" + contactAdministratorsLink + "\">", "</a>") : i18n.getText("500.send.to.your.jira.admin")));
        }
        if (InternalServerErrorHelper.isLoggedInAdmin()) {
            ExternalLinkUtilImpl externalLinkUtil = new ExternalLinkUtilImpl();
            String sac = externalLinkUtil.getProperty("external.link.jira.support.site");
            String stp = req.getContextPath() + "/plugins/servlet/stp/view/#support-zip";
            return ImmutableList.of((Object)i18n.getText("500.collect.when.problem.occurred"), (Object)i18n.getText("500.collect.server.log"), (Object)i18n.getText("500.create.support.zip", "<a target=\"_blank\" href=\"" + stp + "\">", "</a>"), (Object)i18n.getText("500.raise.an.issue.with.all.info", "<a href=\"" + sac + "\">", "</a>"));
        }
        String contactAdministratorsLink = InternalServerErrorHelper.getContactAdministratorLink(req);
        return ImmutableList.of((Object)(contactAdministratorsLink != null ? i18n.getText("500.send.with.ref.to.your.jira.admin.contact.form", "<a target=\"_blank\" href=\"" + contactAdministratorsLink + "\">", "</a>") : i18n.getText("500.send.with.ref.to.your.jira.admin")));
    }

    private static String getContactAdministratorLink(HttpServletRequest req) {
        JiraContactHelper jiraContactHelper = (JiraContactHelper)ComponentAccessor.getComponent(JiraContactHelper.class);
        if (jiraContactHelper == null) {
            return null;
        }
        if (!jiraContactHelper.isAdministratorContactFormEnabled()) {
            return null;
        }
        return jiraContactHelper.getAdministratorContactLink(req.getContextPath());
    }

    private static InternalServerErrorDataSource initializeInternalServerErrorDS(HttpServletRequest req, Logger log) {
        I18nHelper i18nBean = InternalServerErrorHelper.getI18nHelper();
        ExtendedSystemInfoUtilsImpl extendedSystemInfoUtils = null;
        try {
            extendedSystemInfoUtils = new ExtendedSystemInfoUtilsImpl(i18nBean);
        }
        catch (Exception e) {
            log.warn("Cannot initialize ExtendedSystemInfoUtilsImpl", (Throwable)e);
        }
        return new InternalServerErrorDataSource(i18nBean, extendedSystemInfoUtils, req.getSession().getServletContext(), ComponentAccessor.getLocaleManager(), req);
    }

    private static I18nHelper getI18nHelper() {
        return ((JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class)).getI18nHelper();
    }
}

