/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.bc.dataimport.DataImportService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.task.ImportTaskManager;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.template.velocity.VelocityEngineFactory;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.LocaleParser;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.johnson.DefaultJohnsonProvider;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import com.atlassian.jira.web.action.util.ImportResultHandler;
import com.atlassian.jira.web.servletcontext.ServletContextReference;
import com.atlassian.jira.web.util.MetalResourcesManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraImportProgressFilter
extends AbstractHttpFilter {
    private static final Logger log = LoggerFactory.getLogger(JiraImportProgressFilter.class);
    private static final String ALREADY_FILTERED = JiraImportProgressFilter.class.getName() + "_already_filtered";
    private static ServletContextReference<ImportTaskManager> taskManagerReference = new ServletContextReference("jira.import.task.manager");
    private static ServletContextReference<SimpleTaskDescriptorBean> currentTaskReference = new ServletContextReference("jira.import.current.task");
    private ServletContext servletContext;
    private final JohnsonProvider johnsonProvider;

    public JiraImportProgressFilter() {
        this(new DefaultJohnsonProvider());
    }

    @VisibleForTesting
    JiraImportProgressFilter(JohnsonProvider johnsonProvider) {
        this.johnsonProvider = johnsonProvider;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.servletContext = filterConfig.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request.getAttribute(ALREADY_FILTERED) != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
        if (taskManagerReference.get() != null && taskManagerReference.get().getTask() != null) {
            request.setCharacterEncoding("UTF-8");
            response.setContentType("text/html; charset=UTF-8");
            String localeString = request.getParameter("locale");
            Locale locale = Locale.getDefault();
            if (StringUtils.isNotBlank((String)localeString)) {
                locale = LocaleParser.parseLocale((String)localeString);
            }
            SimpleTaskDescriptorBean currentTaskDescriptor = new SimpleTaskDescriptorBean(taskManagerReference.get().getTask(), locale, taskManagerReference.get().getCachedResourceBundleStrings());
            currentTaskReference.set(currentTaskDescriptor);
            if (currentTaskDescriptor.isFinished()) {
                try {
                    DataImportService.ImportResult importResult = currentTaskDescriptor.getResult();
                    request.getSession(true).setAttribute("jira.data.import.result", (Object)importResult);
                    if (Boolean.parseBoolean(request.getParameter("setup"))) {
                        response.sendRedirect(request.getContextPath() + "/secure/SetupImport.jspa");
                    } else if (importResult.isValid()) {
                        ((LoginManager)ComponentAccessor.getComponent(LoginManager.class)).logout(request, response);
                        taskManagerReference.get().clearCachedResourceBundleStrings();
                        response.sendRedirect(request.getContextPath() + "/secure/ImportResult.jspa");
                    } else {
                        this.handleImportErrors(importResult);
                        String url = "/secure/admin/XmlRestore!finish.jspa";
                        if (this.johnsonProvider.getContainer().hasEvents()) {
                            url = "/secure/errors.jsp";
                        }
                        taskManagerReference.get().clearCachedResourceBundleStrings();
                        response.sendRedirect(request.getContextPath() + url);
                    }
                    return;
                }
                catch (ExecutionException e) {
                    currentTaskDescriptor.setExceptionCause(e.getCause() == null ? e : e.getCause());
                    log.error("Error performing import", (Throwable)e);
                }
                catch (InterruptedException e) {
                    currentTaskDescriptor.setExceptionCause(e);
                    log.error("Error performing import", (Throwable)e);
                }
                finally {
                    taskManagerReference.get().shutdownNow();
                    taskManagerReference.set(null);
                    currentTaskReference.set(null);
                }
            }
            this.renderView(request, response, currentTaskDescriptor);
        } else {
            response.sendRedirect(request.getContextPath() + "/");
        }
    }

    private void handleImportErrors(DataImportService.ImportResult lastResult) {
        ImportResultHandler importResultHandler = (ImportResultHandler)ComponentAccessor.getComponent(ImportResultHandler.class);
        importResultHandler.handleErrorResult(lastResult, ComponentAccessor.getI18nHelperFactory().getInstance(ComponentAccessor.getApplicationProperties().getDefaultLocale()), (ErrorCollection)new SimpleErrorCollection());
    }

    private void renderView(HttpServletRequest request, HttpServletResponse response, SimpleTaskDescriptorBean task) throws ServletException {
        try {
            VelocityEngine velocityEngine = new VelocityEngine();
            Properties props = new Properties();
            props.put("resource.loader", "class");
            props.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
            props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            VelocityEngineFactory.Default.enableDevMode(props);
            props.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
            props.setProperty("runtime.log.logsystem.log4j.category", "velocity");
            props.setProperty("velocimacro.library", "");
            velocityEngine.setApplicationAttribute((Object)"javax.servlet.ServletContext", (Object)this.servletContext);
            velocityEngine.init(props);
            Template template = velocityEngine.getTemplate("/templates/jira/importprogress/dataimportprogress.vm");
            VelocityContext context = new VelocityContext();
            context.put("resourcesHtml", (Object)MetalResourcesManager.getMetalResources(request.getContextPath()));
            context.put("task", (Object)task);
            template.merge((Context)context, (Writer)response.getWriter());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static class SimpleTaskDescriptorBean {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat();
        private final TaskDescriptor<DataImportService.ImportResult> descriptor;
        private final Locale locale;
        private Throwable exceptionCause;
        private TaskProgressEvent lastProgressEvent;
        private String description;
        private ResourceBundle resourceBundle;
        private PeriodFormatter periodFormatter;
        private final Map<String, String> cachedResourceBundleStrings;

        SimpleTaskDescriptorBean(TaskDescriptor<DataImportService.ImportResult> descriptor, Locale locale, Map<String, String> cachedResourceBundleStrings) {
            this.descriptor = descriptor;
            this.locale = locale;
            this.description = descriptor.getDescription();
            this.lastProgressEvent = descriptor.getTaskProgressIndicator().getLastProgressEvent();
            this.cachedResourceBundleStrings = cachedResourceBundleStrings;
            this.resourceBundle = DefaultResourceBundle.getDefaultResourceBundle(locale);
            this.periodFormatter = new PeriodFormatterBuilder().printZeroNever().appendHours().appendSuffix(" " + this.getText("common.words.hour"), " " + this.getText("common.words.hours")).appendSeparator(", ").appendMinutes().appendSuffix(" " + this.getText("common.words.minute"), " " + this.getText("common.words.minutes")).appendSeparator(", ").appendSeconds().appendSuffix(" " + this.getText("common.words.second"), " " + this.getText("common.words.seconds")).toFormatter();
        }

        public boolean isFinished() {
            return this.descriptor.isFinished();
        }

        public DataImportService.ImportResult getResult() throws ExecutionException, InterruptedException {
            return this.descriptor.getResult();
        }

        public void setExceptionCause(Throwable throwable) {
            this.exceptionCause = throwable;
        }

        public Throwable getExceptionCause() {
            return this.exceptionCause;
        }

        public long getProgressNumber() {
            if (this.descriptor.isFinished() || this.descriptor.getTaskProgressIndicator() == null) {
                return 100L;
            }
            if (this.lastProgressEvent == null) {
                return 0L;
            }
            return Math.max(Math.min(100L, this.lastProgressEvent.getTaskProgress()), 0L);
        }

        public long getInverseProgressNumber() {
            return 100L - this.getProgressNumber();
        }

        public String getDescription() {
            return this.description;
        }

        public String getProgressMessage() {
            if (this.lastProgressEvent.getCurrentSubTask() != null) {
                return this.lastProgressEvent.getCurrentSubTask() + ": " + this.lastProgressEvent.getMessage();
            }
            return this.lastProgressEvent.getMessage();
        }

        public String getFormattedProgress() {
            if (!this.descriptor.isStarted()) {
                return this.getText("common.tasks.info.starting", this.formattedDate(this.descriptor.getSubmittedTimestamp()));
            }
            if (this.descriptor.isFinished()) {
                if (this.exceptionCause != null) {
                    return this.getText("common.tasks.info.completed.with.error", this.getFormattedElapsedRunTime());
                }
                return this.getText("common.tasks.info.completed", this.getFormattedElapsedRunTime());
            }
            if (this.lastProgressEvent != null && this.lastProgressEvent.getTaskProgress() >= 0L) {
                return this.getText("common.tasks.info.progressing", Long.toString(this.getProgressNumber()), this.getFormattedElapsedRunTime());
            }
            return this.getText("common.tasks.info.progress.unknown", this.getFormattedElapsedRunTime());
        }

        public String getFormattedStartDate() {
            return this.getText("common.tasks.info.started", this.formattedDate(this.descriptor.getStartedTimestamp()));
        }

        private String formattedDate(Date date) {
            return this.dateFormat.format(date);
        }

        public String getFormattedElapsedRunTime() {
            return this.periodFormatter.withLocale(this.locale).print((ReadablePeriod)new Period(this.descriptor.getElapsedRunTime()));
        }

        public TaskProgressEvent getLastProgressEvent() {
            return this.lastProgressEvent;
        }

        public boolean isStarted() {
            return this.descriptor.isStarted();
        }

        public String getText(String key) {
            String text = this.cachedResourceBundleStrings.containsKey(key) ? this.cachedResourceBundleStrings.get(key) : this.resourceBundle.getString(key);
            return MessageFormat.format(text, new Object[0]);
        }

        public String getText(String key, String ... args) {
            String text = this.cachedResourceBundleStrings.containsKey(key) ? this.cachedResourceBundleStrings.get(key) : this.resourceBundle.getString(key);
            return MessageFormat.format(text, args);
        }
    }
}

