/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.label.LabelService;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.jira.web.util.CheckboxTagSupport;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class EditLabels
extends AbstractIssueSelectAction {
    public static final String SEND_NOTIFICATION_CONGLOMERATE_KEY = "labels.send.notification";
    public static final String ISSUE_NOT_FOUND = "issuenotfound";
    private final LabelService labelService;
    private final CustomFieldManager customFieldManager;
    private LabelUtil labelUtil;
    private Long customFieldId;
    private List<String> existingLabels = new ArrayList<String>();
    private Set<String> labels = new LinkedHashSet<String>();
    private boolean noLink;
    private final CheckboxTagSupport sendNotification;

    public EditLabels(LabelService labelService, CustomFieldManager customFieldManager, LabelUtil labelUtil) {
        this.labelService = labelService;
        this.customFieldManager = customFieldManager;
        this.labelUtil = labelUtil;
        this.sendNotification = new CheckboxTagSupport(this.sendNotificationCookieValue());
    }

    public String doDefault() throws Exception {
        try {
            return this.unsafeDoDefault();
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
    }

    private String unsafeDoDefault() throws Exception {
        Issue issue = this.getIssueObject();
        if (issue == null) {
            this.addErrorMessage(this.getText("label.service.error.issue.doesnt.exist", this.getId()));
            return "error";
        }
        LabelService.LabelsResult validationResult = this.getLabelsResult(issue);
        if (validationResult.isValid()) {
            this.addToExistingLabels(validationResult.getLabels());
            return "input";
        }
        this.addErrorCollection(validationResult.getErrorCollection());
        return "error";
    }

    private LabelService.LabelsResult getLabelsResult(Issue issue) {
        LabelService.LabelsResult labelsResult = this.customFieldId == null ? this.labelService.getLabels(this.getLoggedInUser(), issue.getId()) : this.labelService.getLabels(this.getLoggedInUser(), issue.getId(), this.customFieldId);
        return labelsResult;
    }

    public String doViewLinks() throws Exception {
        Issue issue = this.getIssueObject();
        if (issue == null) {
            this.addErrorMessage(this.getText("label.service.error.issue.doesnt.exist", this.getId()));
            return "error";
        }
        LabelService.LabelsResult labelsResult = this.getLabelsResult(issue);
        if (labelsResult.isValid()) {
            this.addToExistingLabels(labelsResult.getLabels());
            return "success";
        }
        return "error";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        LabelService.LabelsResult setLabelsResult;
        LabelService.SetLabelValidationResult setLabelsValidation;
        Issue issue = null;
        try {
            issue = this.getIssueObject();
        }
        catch (IssueNotFoundException e) {
            return ISSUE_NOT_FOUND;
        }
        catch (IssuePermissionException e) {
            return ISSUE_NOT_FOUND;
        }
        if (this.sendNotification.hasChanged()) {
            this.setSendNotificationCookie();
        }
        if ((setLabelsValidation = this.customFieldId == null ? this.labelService.validateSetLabels(this.getLoggedInUser(), issue.getId(), this.labels) : this.labelService.validateSetLabels(this.getLoggedInUser(), issue.getId(), this.customFieldId, this.labels)).isValid() && (setLabelsResult = this.labelService.setLabels(this.getLoggedInUser(), setLabelsValidation, this.sendNotification.postAction(), true)).isValid()) {
            this.addToExistingLabels(setLabelsResult.getLabels());
            return this.returnComplete(this.getViewUrl());
        }
        this.existingLabels.addAll(setLabelsValidation.getLabels());
        this.addErrorCollection(setLabelsValidation.getErrorCollection());
        return "error";
    }

    public String getDomId() {
        if (this.customFieldId != null) {
            return "customfield_" + this.customFieldId;
        }
        return "labels";
    }

    public Long getCustomFieldId() {
        return this.customFieldId;
    }

    public String getErrorCollectionKey() {
        if (this.customFieldId == null) {
            return "labels";
        }
        CustomField field = this.customFieldManager.getCustomFieldObject(this.customFieldId);
        if (field != null) {
            return field.getId();
        }
        return "";
    }

    public String getFieldName() {
        if (this.customFieldId == null) {
            return this.getText("issue.field.labels");
        }
        CustomField field = this.customFieldManager.getCustomFieldObject(this.customFieldId);
        if (field != null) {
            return field.getName();
        }
        return "";
    }

    public String getLabelNavigatorUrl(String label) {
        if (this.customFieldId == null) {
            return this.labelUtil.getLabelJql(this.getLoggedInUser(), label);
        }
        return this.labelUtil.getLabelJql(this.getLoggedInUser(), this.customFieldId, label);
    }

    public void setCustomFieldId(Long customFieldId) {
        this.customFieldId = customFieldId;
    }

    public List<String> getExistingLabels() {
        return this.existingLabels;
    }

    public void setLabels(String[] labels) {
        this.labels.addAll(Arrays.asList(labels));
    }

    public boolean isNoLink() {
        return this.noLink;
    }

    public void setNoLink(boolean noLink) {
        this.noLink = noLink;
    }

    public boolean isSendNotification() {
        return this.sendNotification.preAction();
    }

    public void setSendNotification(boolean doSendNotification) {
        this.sendNotification.postAction(doSendNotification);
    }

    private boolean sendNotificationCookieValue() {
        return Boolean.valueOf(this.getConglomerateCookieValue("jira.conglomerate.cookie", SEND_NOTIFICATION_CONGLOMERATE_KEY));
    }

    private void setSendNotificationCookie() {
        String value = this.sendNotification.postAction() ? "true" : "";
        this.setConglomerateCookieValue("jira.conglomerate.cookie", SEND_NOTIFICATION_CONGLOMERATE_KEY, value);
    }

    private void addToExistingLabels(Set<Label> labels) {
        this.existingLabels.addAll((Collection<String>)ImmutableList.copyOf((Iterable)Iterables.transform(labels, (Function)new LabelToName())));
    }

    static class LabelToName
    implements Function<Label, String> {
        LabelToName() {
        }

        public String apply(Label label) {
            return label.getLabel();
        }
    }
}

