/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.bonfire;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

@WebSudoRequired
public class SetupBonfire
extends JiraWebActionSupport {
    private static final String COM_ATLASSIAN_BONFIRE_PLUGIN = "com.atlassian.bonfire.plugin";
    private static final String BONFIRE_LICENSE_KEY = "bonfire-license";
    private static final String KEY_EX_PROPS = "Excalibur.properties";
    private static final long GLOBAL_ENTITY_ID = 1L;
    private final ExternalLinkUtil externalLinkUtil;
    private final PluginAccessor pluginAccessor;
    private final JiraLicenseService licenseService;
    private final PluginController pluginController;
    private String license;

    public SetupBonfire(ExternalLinkUtil externalLinkUtil, PluginAccessor pluginAccessor, JiraLicenseService licenseService, PluginController pluginController) {
        this.externalLinkUtil = externalLinkUtil;
        this.pluginAccessor = pluginAccessor;
        this.licenseService = licenseService;
        this.pluginController = pluginController;
    }

    public String doFetchLicense() throws Exception {
        return "input";
    }

    public String doReturnFromMAC() throws Exception {
        return "input";
    }

    public String doDefault() throws Exception {
        this.doValidation();
        return super.doDefault();
    }

    protected void doValidation() {
        boolean isBonfireInstalled;
        boolean bl = isBonfireInstalled = this.pluginAccessor.getPlugin(COM_ATLASSIAN_BONFIRE_PLUGIN) != null;
        if (!isBonfireInstalled) {
            this.addErrorMessage(this.getText("setup.bonfire.no.plugin"));
        }
        super.doValidation();
    }

    private JiraLicenseService getLicenseService() {
        return (JiraLicenseService)ComponentAccessor.getComponent(JiraLicenseService.class);
    }

    protected String doExecute() throws Exception {
        StringBuilder url = new StringBuilder();
        url.append(JiraUrl.constructBaseUrl((HttpServletRequest)this.request));
        url.append("/plugins/servlet/upm#manage/com.atlassian.bonfire.plugin");
        return this.getRedirect(url.toString());
    }

    private ErrorCollection invokeBonfireSetLicence() throws Exception {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        Plugin plugin = this.pluginAccessor.getPlugin(COM_ATLASSIAN_BONFIRE_PLUGIN);
        if (plugin == null) {
            errorCollection.addErrorMessage("setup.bonfire.no.plugin");
        } else {
            this.pluginController.enablePlugins(new String[]{COM_ATLASSIAN_BONFIRE_PLUGIN});
            ModuleDescriptor moduleDescriptor = plugin.getModuleDescriptor("bonfire-license-service");
            if (moduleDescriptor == null) {
                errorCollection.addErrorMessage(this.getText("setup.bonfire.no.licence.module"));
            } else {
                Object bonfireLicenceService = moduleDescriptor.getModule();
                Method validateAndSetLicence = bonfireLicenceService.getClass().getMethod("validateAndSetLicence", ErrorCollection.class, String.class);
                validateAndSetLicence.invoke(bonfireLicenceService, errorCollection, this.getLicense());
            }
        }
        return errorCollection;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getRequestEvaluatorLicenseURL() throws UnsupportedEncodingException {
        return this.externalLinkUtil.getProperty("external.link.bonfire.license.evaluator", Arrays.asList(COM_ATLASSIAN_BONFIRE_PLUGIN));
    }

    public String getOrganisation() {
        Iterator iterator = this.licenseService.getLicenses().iterator();
        if (iterator.hasNext()) {
            LicenseDetails license = (LicenseDetails)iterator.next();
            return license.getOrganisation();
        }
        return "";
    }

    public String getCallbackUrl() throws UnsupportedEncodingException {
        StringBuilder url = new StringBuilder();
        url.append(JiraUrl.constructBaseUrl((HttpServletRequest)this.request));
        url.append("/plugins/servlet/upm/license/com.atlassian.bonfire.plugin");
        return url.toString();
    }

    public boolean isPluginInstalled() {
        return this.pluginAccessor.getPlugin(COM_ATLASSIAN_BONFIRE_PLUGIN) != null;
    }
}

