/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class ViewCustomFields
extends JiraWebActionSupport {
    private final CustomFieldManager customFieldManager;
    private final FieldScreenManager fieldScreenManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final FeatureManager featureManager;
    private final TranslationManager translationManager;
    private Map fieldScreenTabMap;

    public ViewCustomFields(CustomFieldManager customFieldManager, FieldScreenManager fieldScreenManager, ManagedConfigurationItemService managedConfigurationItemService, FeatureManager featureManager, TranslationManager translationManager) {
        this.customFieldManager = customFieldManager;
        this.fieldScreenManager = fieldScreenManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.featureManager = featureManager;
        this.translationManager = translationManager;
        this.fieldScreenTabMap = new HashMap();
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    public String doReset() throws Exception {
        this.customFieldManager.refresh();
        return super.doDefault();
    }

    public List<CustomField> getCustomFields() throws Exception {
        return this.customFieldManager.getCustomFieldObjects();
    }

    public boolean isCustomFieldTypesExist() {
        List fieldTypes = this.customFieldManager.getCustomFieldTypes();
        return fieldTypes != null && !fieldTypes.isEmpty();
    }

    public boolean isHasConfigurableOptions(CustomField customField) {
        return customField.getCustomFieldType() instanceof MultipleSettableCustomFieldType;
    }

    public Collection getFieldScreenTabs(OrderableField orderableField) {
        String fieldId = orderableField.getId();
        if (!this.fieldScreenTabMap.containsKey(fieldId)) {
            this.fieldScreenTabMap.put(fieldId, this.fieldScreenManager.getFieldScreenTabs(orderableField.getId()));
        }
        return (Collection)this.fieldScreenTabMap.get(fieldId);
    }

    public boolean isFieldManaged(CustomField field) {
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(field);
        return item.isManaged();
    }

    public boolean isMultiLingual() {
        Map installedLocales = this.translationManager.getInstalledLocales();
        return installedLocales.size() > 1;
    }

    public boolean isFieldLocked(CustomField field) {
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(field);
        if (!item.isManaged()) {
            return false;
        }
        return !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), item);
    }

    public String getManagedFieldDescriptionKey(CustomField field) {
        ManagedConfigurationItem item = this.managedConfigurationItemService.getManagedCustomField(field);
        String descriptionI18nKey = item.getDescriptionI18nKey();
        if (StringUtils.isBlank((String)descriptionI18nKey)) {
            return "";
        }
        return descriptionI18nKey;
    }

    public boolean isOnDemand() {
        return this.featureManager.isOnDemand();
    }
}

