/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;

final class UserWithPermissions {
    private final User user;
    private final boolean hasUsePermission;
    private final boolean hasAdminPermission;

    UserWithPermissions(User user, boolean hasUsePermission, boolean hasAdminPermission) {
        this.user = (User)Assertions.notNull((String)"user", (Object)user);
        this.hasUsePermission = hasUsePermission;
        this.hasAdminPermission = hasAdminPermission;
    }

    User getUser() {
        return this.user;
    }

    boolean hasUsePermission() {
        return this.hasUsePermission;
    }

    boolean hasAdminPermission() {
        return this.hasAdminPermission;
    }

    boolean canLogin() {
        return this.hasUsePermission() || this.hasAdminPermission();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserWithPermissions that = (UserWithPermissions)o;
        return Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("user", (Object)this.user).append("hasUsePermission", this.hasUsePermission).append("hasAdminPermission", this.hasAdminPermission).toString();
    }
}

