/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.license.Jira6xServiceDeskPluginEncodedLicenseSupplier;
import com.atlassian.jira.upgrade.tasks.role.License;
import com.atlassian.jira.upgrade.tasks.role.LicenseUtils;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.upgrade.tasks.role.MigrationState;
import com.atlassian.jira.upgrade.tasks.role.MigrationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Move6xServiceDeskLicenseTo70Store
extends MigrationTask {
    private static final Logger log = LoggerFactory.getLogger(Move6xServiceDeskLicenseTo70Store.class);
    private final Jira6xServiceDeskPluginEncodedLicenseSupplier sdEncodedLicenseSupplier;

    Move6xServiceDeskLicenseTo70Store(Jira6xServiceDeskPluginEncodedLicenseSupplier sdEncodedLicenseSupplier) {
        this.sdEncodedLicenseSupplier = sdEncodedLicenseSupplier;
    }

    @Override
    MigrationState migrate(MigrationState state) {
        if (this.serviceDeskLicenseAlreadyExists(state)) {
            return state;
        }
        return (MigrationState)this.sdEncodedLicenseSupplier.get().map(License::new).filter(this::isValid6xServiceDeskLicense).map(sdLicense -> state.changeLicenses(license2 -> license2.addLicense((License)sdLicense))).getOrElse((Object)state);
    }

    private boolean serviceDeskLicenseAlreadyExists(MigrationState state) {
        return state.licenses().keys().contains(ApplicationKeys.SERVICE_DESK);
    }

    private boolean isValid6xServiceDeskLicense(License license) {
        try {
            LicenseUtils.ServiceDeskLicenseType licenseType = LicenseUtils.determineServiceDeskLicenseType(license);
            if (licenseType == LicenseUtils.ServiceDeskLicenseType.TierBasedPricing || licenseType == LicenseUtils.ServiceDeskLicenseType.AgentBasedPricing) {
                return true;
            }
        }
        catch (MigrationFailedException migrationFailedException) {
            // empty catch block
        }
        log.debug("Invalid Service Desk license in plugin store.");
        return false;
    }
}

