/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.role;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.fugue.Option;
import com.atlassian.jira.upgrade.tasks.role.ApplicationRole;
import com.atlassian.jira.upgrade.tasks.role.MigrationFailedException;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class ApplicationRoles {
    private final Map<ApplicationKey, ApplicationRole> roles;

    private ApplicationRoles(ImmutableMap<ApplicationKey, ApplicationRole> roles) {
        this.roles = roles;
    }

    ApplicationRoles(Iterable<ApplicationRole> roles) {
        Assertions.notNull((String)"roles", roles);
        HashMap roleIndex = Maps.newHashMap();
        for (ApplicationRole newRole : roles) {
            ApplicationRole oldRole = roleIndex.put(newRole.key(), newRole);
            if (oldRole == null) continue;
            throw new MigrationFailedException(String.format("Duplicate Application Role %s.", newRole.key()));
        }
        this.roles = ImmutableMap.copyOf((Map)roleIndex);
    }

    Option<ApplicationRole> get(ApplicationKey key) {
        Assertions.notNull((String)"key", (Object)key);
        return Option.option((Object)this.roles.get(key));
    }

    ApplicationRoles put(ApplicationRole role) {
        Assertions.notNull((String)"role", (Object)role);
        HashMap roleIndex = Maps.newHashMap(this.roles);
        roleIndex.put(role.key(), role);
        return new ApplicationRoles((ImmutableMap<ApplicationKey, ApplicationRole>)ImmutableMap.copyOf((Map)roleIndex));
    }

    Map<ApplicationKey, ApplicationRole> asMap() {
        return this.roles;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationRoles that = (ApplicationRoles)o;
        return this.roles.equals(that.roles);
    }

    public int hashCode() {
        return this.roles.hashCode();
    }

    public String toString() {
        return this.roles.toString();
    }
}

