/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.upgrade.LegacyImmediateUpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build6301
extends LegacyImmediateUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask_Build6301.class);
    private static String ENTITY_NAME = "AuditLog";
    private static String TABLE_NAME = "audit_log";

    @Override
    public String getBuildNumber() {
        return "6301";
    }

    @Override
    public String getShortDescription() {
        return "Fix field type for AuditLog searchField";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) {
        block6: {
            try {
                if (!this.isPostgreSQL()) break block6;
                ModelEntity auditLogTable = UpgradeTask_Build6301.getOfBizDelegator().getModelReader().getModelEntity(ENTITY_NAME);
                String searchFieldColumn = auditLogTable.getField("searchField").getColName();
                try (Connection connection = this.getDatabaseConnection();){
                    Statement statement = connection.createStatement();
                    statement.execute("ALTER TABLE " + this.convertToSchemaTableName(TABLE_NAME) + " ALTER COLUMN " + searchFieldColumn + " SET DATA TYPE TEXT");
                }
            }
            catch (SQLException e) {
                log.warn("Problem while changing field type for audit_log search_field. If search_field is already of type text this can be safely ignored.", (Throwable)e);
            }
            catch (GenericEntityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    @Nullable
    public String dependsUpon() {
        return "6258";
    }
}

