/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.startup.FailedStartupCheck;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.util.ExceptionUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSystemLauncher
implements JiraLauncher {
    private static final Logger log = LoggerFactory.getLogger(PluginSystemLauncher.class);

    @Override
    public void start() {
        try {
            ComponentManager.getInstance().start();
            this.clearTomcatResources();
        }
        catch (Exception ex) {
            log.error("A fatal error occured during initialisation. JIRA has been locked.", (Throwable)ex);
            JiraStartupChecklist.setFailedStartupCheck(new FailedStartupCheck("Component Manager", ExceptionUtil.getMessage(ex)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTomcatResources() {
        block8: {
            try {
                Map resourceEntries;
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> contextClassLoaderClass = contextClassLoader.getClass();
                if (!"org.apache.catalina.loader.WebappClassLoader".equals(contextClassLoaderClass.getName())) break block8;
                Field resourceEntriesField = contextClassLoaderClass.getDeclaredField("resourceEntries");
                resourceEntriesField.setAccessible(true);
                Map map = resourceEntries = (Map)resourceEntriesField.get(contextClassLoader);
                synchronized (map) {
                    resourceEntriesField.set(contextClassLoader, new HashMap());
                }
            }
            catch (NoSuchFieldException exception) {
                log.warn(String.format("Tomcat's WebappClassLoader cache for resourceEntries not cleared.Probably using different Tomcat version than 6 or 7 Message: %s", ExceptionUtil.getMessage(exception)));
            }
            catch (IllegalAccessException exception) {
                log.warn("Tomcat's WebappClassLoader cache for resourceEntries not cleared. This should never happen?", (Throwable)exception);
            }
            catch (SecurityException exception) {
                log.warn("Tomcat's WebappClassLoader cache for resourceEntries not cleared. Have we started to use security managers?", (Throwable)exception);
            }
            catch (Exception exception) {
                log.warn(String.format("Tomcat's WebappClassLoader cache for resourceEntries not cleared. Message: %s", ExceptionUtil.getMessage(exception)));
            }
        }
    }

    @Override
    public void stop() {
        ComponentManager.getInstance().stop();
    }
}

