/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.transaction;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionRuntimeException;
import com.atlassian.jira.transaction.TransactionSupport;
import org.ofbiz.core.entity.GenericTransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionSupportImpl
implements TransactionSupport {
    private static final Logger log = LoggerFactory.getLogger(TransactionSupportImpl.class);
    private static final Transaction NO_OP = new Transaction(){

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void finallyRollbackIfNotCommitted() throws TransactionRuntimeException {
        }

        @Override
        public boolean isNewTransaction() {
            return false;
        }
    };
    private final ApplicationProperties applicationProperties;

    public TransactionSupportImpl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public Transaction begin() throws TransactionRuntimeException {
        if (this.startedTransaction(false)) {
            return new TransactionImpl();
        }
        return new JoinedTransaction();
    }

    private boolean startedTransaction(boolean forceTxn) throws TransactionRuntimeException {
        if (!forceTxn && this.applicationProperties.getOption("jira.db.txns.disabled")) {
            return false;
        }
        return this.beginTxn();
    }

    boolean beginTxn() throws TransactionRuntimeException {
        try {
            return CoreTransactionUtil.begin();
        }
        catch (GenericTransactionException e) {
            throw new TransactionRuntimeException(e);
        }
    }

    private static class JoinedTransaction
    implements Transaction {
        private boolean committed = false;

        private JoinedTransaction() {
        }

        @Override
        public void commit() {
            this.committed = true;
        }

        @Override
        public void rollback() throws TransactionRuntimeException {
            if (this.committed) {
                throw new IllegalStateException("The transaction has already been committed and hence you cannot rollback");
            }
            try {
                CoreTransactionUtil.setRollbackOnly(false);
            }
            catch (GenericTransactionException e) {
                log.error("Unable to rollback transaction : " + e.getMessage(), (Throwable)e);
                throw new TransactionRuntimeException(e);
            }
        }

        @Override
        public void finallyRollbackIfNotCommitted() {
            if (!this.committed) {
                try {
                    this.rollback();
                }
                catch (TransactionRuntimeException transactionRuntimeException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isNewTransaction() {
            return false;
        }
    }

    private static class TransactionImpl
    implements Transaction {
        private boolean committed = false;

        private TransactionImpl() {
        }

        @Override
        public void commit() throws TransactionRuntimeException {
            try {
                CoreTransactionUtil.commit(true);
                this.committed = true;
            }
            catch (GenericTransactionException e) {
                log.error("Unable to commit transaction : " + e.getMessage(), (Throwable)e);
                throw new TransactionRuntimeException(e);
            }
        }

        @Override
        public void rollback() throws TransactionRuntimeException {
            if (this.committed) {
                throw new IllegalStateException("The transaction has already been committed and hence you cannot rollback");
            }
            try {
                CoreTransactionUtil.rollback(true);
            }
            catch (GenericTransactionException e) {
                log.error("Unable to rollback transaction : " + e.getMessage(), (Throwable)e);
                throw new TransactionRuntimeException(e);
            }
        }

        @Override
        public void finallyRollbackIfNotCommitted() {
            if (!this.committed) {
                try {
                    this.rollback();
                }
                catch (TransactionRuntimeException transactionRuntimeException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isNewTransaction() {
            return true;
        }
    }
}

