/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.LifecycleAwareSchedulerService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraSchedulerLauncher
implements JiraLauncher {
    private static final Logger log = LoggerFactory.getLogger(JiraSchedulerLauncher.class);

    @Override
    public void start() {
        try {
            this.proceedIfAllClear();
        }
        catch (RuntimeException rte) {
            log.error("A RuntimeException occurred during JiraSchedulerLauncher servlet context initialisation - " + rte.getMessage() + ".", (Throwable)rte);
            throw rte;
        }
        catch (Error error) {
            log.error("An Error occurred during JiraSchedulerLauncher servlet context initialisation - " + error.getMessage() + ".", (Throwable)error);
            throw error;
        }
    }

    protected void proceedIfAllClear() {
        if (this.checkAllClear()) {
            log.info("Starting the JIRA Scheduler....");
            try {
                ((LifecycleAwareSchedulerService)ComponentAccessor.getComponent(LifecycleAwareSchedulerService.class)).start();
                log.info("JIRA Scheduler started.");
            }
            catch (SchedulerServiceException e) {
                log.error("Error starting scheduler", (Throwable)e);
            }
        }
    }

    protected boolean checkAllClear() {
        boolean ok = false;
        if (!JiraStartupChecklist.startupOK()) {
            log.info("JIRA Scheduler not started: JIRA startup checklist failed.");
        } else if (!this.thereAreNoJohnsonEvents()) {
            log.info("JIRA Scheduler not started: Johnson events detected.");
        } else if (!this.canCreateScheduler()) {
            log.info("JIRA Scheduler not started: JIRA not setup yet.");
        } else {
            ok = true;
        }
        return ok;
    }

    private boolean thereAreNoJohnsonEvents() {
        JohnsonEventContainer cont = ((JohnsonProvider)ComponentAccessor.getComponent(JohnsonProvider.class)).getContainer();
        if (cont == null) {
            return true;
        }
        Collection events = cont.getEvents();
        return events.isEmpty();
    }

    protected boolean canCreateScheduler() {
        return ComponentAccessor.getApplicationProperties().getString("jira.setup") != null;
    }

    @Override
    public void stop() {
        LifecycleAwareSchedulerService schedulerService = (LifecycleAwareSchedulerService)ComponentAccessor.getComponent(LifecycleAwareSchedulerService.class);
        if (schedulerService != null) {
            schedulerService.shutdown();
        }
    }
}

