/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.util;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.util.ProjectKeyCache;
import com.atlassian.jira.project.util.ProjectKeyStore;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@EventComponent
public class CachingProjectKeyStore
implements ProjectKeyStore {
    private final ProjectKeyStore delegateProjectKeyStore;
    private final CachedReference<ProjectKeyCache> cache;

    public CachingProjectKeyStore(ProjectKeyStore delegateProjectKeyStore, CacheManager cacheManager) {
        this.delegateProjectKeyStore = delegateProjectKeyStore;
        this.cache = cacheManager.getCachedReference(CachingProjectKeyStore.class.getName() + ".cache", (Supplier)new ProjectKeyCacheSupplier());
        this.refresh();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    @Nullable
    public Long getProjectId(String key) {
        return ((ProjectKeyCache)this.cache.get()).getProjectId(key);
    }

    @Override
    public void addProjectKey(Long projectId, String projectKey) {
        this.delegateProjectKeyStore.addProjectKey(projectId, projectKey);
        this.refresh();
    }

    @Override
    public void deleteProjectKeys(Long projectId) {
        this.delegateProjectKeyStore.deleteProjectKeys(projectId);
        this.refresh();
    }

    @Override
    @Nonnull
    public Map<String, Long> getAllProjectKeys() {
        return ((ProjectKeyCache)this.cache.get()).getAllProjectKeys();
    }

    @Override
    @Nullable
    public Long getProjectIdByKeyIgnoreCase(String projectKey) {
        return ((ProjectKeyCache)this.cache.get()).getProjectIdByKeyIgnoreCase(projectKey);
    }

    @Override
    @Nonnull
    public Set<String> getProjectKeys(Long projectId) {
        return ((ProjectKeyCache)this.cache.get()).getProjectKeys(projectId);
    }

    @Override
    public void refresh() {
        this.cache.reset();
    }

    private class ProjectKeyCacheSupplier
    implements Supplier<ProjectKeyCache> {
        private ProjectKeyCacheSupplier() {
        }

        public ProjectKeyCache get() {
            return new ProjectKeyCache(CachingProjectKeyStore.this.delegateProjectKeyStore);
        }
    }
}

