/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.type;

import com.atlassian.jira.exception.UpdateException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeUpdatedHandler;
import com.atlassian.jira.project.type.ProjectTypeUpdatedNotifier;
import com.atlassian.jira.project.type.ProjectTypeUpdatedRegistrar;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectTypeUpdatedRegistrarImpl
implements ProjectTypeUpdatedRegistrar,
ProjectTypeUpdatedNotifier {
    private static final Logger log = LoggerFactory.getLogger(ProjectTypeUpdatedRegistrarImpl.class);
    protected final Map<String, ProjectTypeUpdatedHandler> handlers = new ConcurrentHashMap<String, ProjectTypeUpdatedHandler>();

    @Override
    public boolean notifyAllHandlers(Project project, ProjectTypeKey oldProjectType, ProjectTypeKey newProjectType) {
        ArrayList notifiedHandlers = Lists.newArrayList();
        boolean handlersWereSuccessful = true;
        for (ProjectTypeUpdatedHandler handler2 : this.getHandlers()) {
            try {
                notifiedHandlers.add(handler2);
                handler2.onProjectTypeUpdated(project, oldProjectType, newProjectType);
            }
            catch (UpdateException | RuntimeException exception) {
                log.error("The handler with id " + handler2.getHandlerId() + " threw an exception while handling a notification about a project type update", exception);
                handlersWereSuccessful = false;
                break;
            }
        }
        if (!handlersWereSuccessful) {
            notifiedHandlers.forEach(handler -> handler.onProjectTypeUpdateRolledBack(project, oldProjectType, newProjectType));
        }
        return handlersWereSuccessful;
    }

    @VisibleForTesting
    protected Collection<ProjectTypeUpdatedHandler> getHandlers() {
        return this.handlers.values();
    }

    public void register(ProjectTypeUpdatedHandler handlerToAdd) {
        this.handlers.put(handlerToAdd.getHandlerId(), handlerToAdd);
    }

    public void unregister(ProjectTypeUpdatedHandler handlerToRemove) {
        this.handlers.remove(handlerToRemove.getHandlerId());
    }
}

