/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.cache.CacheFactory;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.event.ClearSpecCacheEvent;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.config.FeatureEvent;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.i18n.CachingI18nFactory;
import com.atlassian.jira.plugin.webresource.JiraBaseUrlCDNStrategy;
import com.atlassian.jira.plugin.webresource.JiraPrefixCDNStrategy;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class JiraWebResourceIntegration
implements WebResourceIntegration,
InitializingComponent {
    static final String CDN_DISABLED_FEATURE_KEY = "jira.cdn.disabled";
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory requestContextFactory;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CachingI18nFactory i18nFactory;
    private final JiraHome jiraHome;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final PluginEventManager pluginEventManager;
    private final CacheFactory cacheFactory;

    public JiraWebResourceIntegration(PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, VelocityRequestContextFactory requestContextFactory, BuildUtilsInfo buildUtilsInfo, JiraAuthenticationContext jiraAuthenticationContext, CachingI18nFactory i18nFactory, JiraHome jiraHome, EventPublisher eventPublisher, FeatureManager featureManager, PluginEventManager pluginEventManager, CacheFactory cacheFactory) {
        this.i18nFactory = i18nFactory;
        this.cacheFactory = cacheFactory;
        this.pluginAccessor = (PluginAccessor)Assertions.notNull((String)"pluginAccessor", (Object)pluginAccessor);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.requestContextFactory = (VelocityRequestContextFactory)Assertions.notNull((String)"requestContextFactory", (Object)requestContextFactory);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Assertions.notNull((String)"jiraAuthenticationContext", (Object)jiraAuthenticationContext);
        this.jiraHome = (JiraHome)Assertions.notNull((String)"jiraHome", (Object)jiraHome);
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.pluginEventManager = pluginEventManager;
    }

    @EventListener
    public void onCdnDisabled(FeatureEvent featureEvent) {
        if (featureEvent.feature().equals(CDN_DISABLED_FEATURE_KEY) || featureEvent.feature().equals("jira.fixed.cdn.enabled") || featureEvent.feature().equals("jira.baseurl.cdn.enabled")) {
            this.eventPublisher.publish((Object)new ClearSpecCacheEvent());
        }
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public PluginEventManager getPluginEventManager() {
        return this.pluginEventManager;
    }

    public CacheFactory getCacheFactory() {
        return this.cacheFactory;
    }

    public Map<String, Object> getRequestCache() {
        return JiraAuthenticationContextImpl.getRequestCache();
    }

    public String getSystemCounter() {
        return this.applicationProperties.getDefaultBackedString("jira.webresource.flushcounter");
    }

    public String getSystemBuildNumber() {
        return this.buildUtilsInfo.getCurrentBuildNumber();
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.AUTO);
    }

    public String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case RELATIVE: {
                HttpServletRequest httpServletRequest = ExecutingHttpRequest.get();
                if (httpServletRequest != null) {
                    return httpServletRequest.getContextPath();
                }
            }
            case AUTO: {
                return this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
            }
            case ABSOLUTE: {
                return this.requestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
            }
        }
        throw new AssertionError((Object)("Unsupported URLMode: " + urlMode));
    }

    public String getSuperBatchVersion() {
        return this.applicationProperties.getDefaultBackedString("jira.webresource.superbatch.flushcounter");
    }

    public String getStaticResourceLocale() {
        I18nHelper i18n = this.jiraAuthenticationContext.getI18nHelper();
        return i18n.getLocale().toString() + this.i18nFactory.getStateHashCode();
    }

    @Nonnull
    public File getTemporaryDirectory() {
        return new File(this.jiraHome.getLocalHome(), "tmp" + File.separator + "webresources");
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public CDNStrategy getCDNStrategy() {
        boolean disabled = this.featureManager.isEnabled(CDN_DISABLED_FEATURE_KEY);
        if (!disabled) {
            if (this.featureManager.isEnabled("jira.baseurl.cdn.enabled")) {
                return new JiraBaseUrlCDNStrategy(this.applicationProperties);
            }
            if (this.featureManager.isEnabled("jira.fixed.cdn.enabled")) {
                return new JiraPrefixCDNStrategy();
            }
        }
        return null;
    }

    public Locale getLocale() {
        return this.jiraAuthenticationContext.getLocale();
    }

    public String getI18nRawText(Locale locale, String key) {
        return this.i18nFactory.getInstance(locale).getUnescapedText(key);
    }

    public String getI18nText(Locale locale, String key) {
        return this.i18nFactory.getInstance(locale).getText(key);
    }
}

