/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.plugin.profile.UserFormat;
import com.atlassian.jira.plugin.userformat.UserFormatModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.GroupPermissionChecker;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.component.webfragment.ViewUserProfileContextLayoutBean;
import com.atlassian.jira.web.component.webfragment.WebFragmentWebComponent;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

public class FullProfileUserFormat
implements UserFormat {
    private final EmailFormatter emailFormatter;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final GroupPermissionChecker groupPermissionChecker;
    private final WebFragmentWebComponent webFragmentWebComponent;
    private final UserManager userManager;
    private final UserKeyService userKeyService;
    private final UserFormatModuleDescriptor moduleDescriptor;
    private final UserPropertyManager userPropertyManager;
    private final GroupManager groupManager;

    public FullProfileUserFormat(EmailFormatter emailFormatter, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, GroupPermissionChecker groupPermissionChecker, WebFragmentWebComponent webFragmentWebComponent, UserManager userManager, UserKeyService userKeyService, UserFormatModuleDescriptor moduleDescriptor, UserPropertyManager userPropertyManager, GroupManager groupManager) {
        this.emailFormatter = emailFormatter;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.groupPermissionChecker = groupPermissionChecker;
        this.webFragmentWebComponent = webFragmentWebComponent;
        this.userManager = userManager;
        this.userKeyService = userKeyService;
        this.moduleDescriptor = moduleDescriptor;
        this.userPropertyManager = userPropertyManager;
        this.groupManager = groupManager;
    }

    @HtmlSafe
    public String format(String key, String id) {
        ApplicationUser user = null;
        String username = null;
        if (key != null) {
            user = this.userManager.getUserByKey(key);
            username = this.getUsername(key, user);
        }
        Map params = MapBuilder.newBuilder().add((Object)"username", username).add((Object)"user", (Object)user).add((Object)"action", (Object)this).add((Object)"navWebFragment", (Object)this.webFragmentWebComponent).add((Object)"id", (Object)id).toMap();
        return this.moduleDescriptor.getHtml("view", params);
    }

    @HtmlSafe
    public String format(String key, String id, Map params) {
        return this.format(key, id);
    }

    public boolean isUserLoggedinUser(ApplicationUser user) {
        return user.equals((Object)this.authenticationContext.getUser());
    }

    public boolean isEmailVisible(ApplicationUser user) {
        return this.emailFormatter.emailVisible(user);
    }

    private String getUsername(String key, ApplicationUser user) {
        if (user != null) {
            return user.getUsername();
        }
        String name = this.userKeyService.getUsernameForKey(key);
        if (name != null) {
            return name;
        }
        return key;
    }

    @HtmlSafe
    public String getDisplayEmail(ApplicationUser user) {
        return this.emailFormatter.formatEmailAsLink(user.getEmailAddress(), user);
    }

    public boolean hasViewGroupPermission(String group) {
        return this.groupPermissionChecker.hasViewGroupPermission(group, this.authenticationContext.getUser());
    }

    @HtmlSafe
    public String getUserLinks(ApplicationUser profileUser, String template) {
        HttpServletRequest servletRequest = ActionContext.getRequest();
        ViewUserProfileContextLayoutBean userNavLayout = new ViewUserProfileContextLayoutBean(profileUser, (String)ActionContext.getValueStack().findValue("/actionName"));
        servletRequest.setAttribute("profileUser", (Object)profileUser);
        Map params = MapBuilder.build((Object)"profileUser", (Object)profileUser);
        JiraHelper helper = new JiraHelper(servletRequest, null, params);
        return this.webFragmentWebComponent.getHtml(template, "system.user.profile.links", helper, userNavLayout);
    }

    public Map getUserProperties(ApplicationUser user) {
        HashMap userProperties = Maps.newHashMap();
        if (user != null && this.isHasPermission(0)) {
            PropertySet userPropertySet = this.userPropertyManager.getPropertySet(user);
            for (Object userPropertyKeyAsObject : userPropertySet.getKeys(5)) {
                String userPropertyKeyAsString = (String)userPropertyKeyAsObject;
                if (!userPropertyKeyAsString.startsWith("jira.meta.")) continue;
                userProperties.put(userPropertyKeyAsString.substring("jira.meta.".length()), userPropertySet.getString(userPropertyKeyAsString));
            }
        }
        return userProperties;
    }

    public boolean isHasPermission(int permissionsId) {
        return this.permissionManager.hasPermission(permissionsId, this.authenticationContext.getUser());
    }

    public List<String> getGroupNames(ApplicationUser user) {
        String username;
        String string = username = user == null ? null : user.getName();
        if (username == null) {
            return Collections.emptyList();
        }
        Collection groups = this.groupManager.getGroupsForUser(username);
        ArrayList<String> groupNames = new ArrayList<String>(groups.size());
        for (Group group : groups) {
            groupNames.add(group.getName());
        }
        return groupNames;
    }
}

