/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.exception.GetException;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class RemoteLinksByGlobalIdFunction
extends AbstractJqlFunction {
    public static final String FUNCTION_REMOTE_LINKS_BY_GLOBAL_ID = "issuesWithRemoteLinksByGlobalId";
    private final IssueLinkManager issueLinkManager;
    private final RemoteIssueLinkManager remoteIssueLinkManager;

    public RemoteLinksByGlobalIdFunction(IssueLinkManager issueLinkManager, RemoteIssueLinkManager remoteIssueLinkManager) {
        this.issueLinkManager = issueLinkManager;
        this.remoteIssueLinkManager = remoteIssueLinkManager;
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull FunctionOperand operand, @Nonnull TerminalClause terminalClause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        if (!this.issueLinkManager.isLinkingEnabled()) {
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.issue.linking.disabled", this.getFunctionName()));
            return messageSet;
        }
        List args = operand.getArgs();
        int maxArgSize = 100;
        if (args.size() < 1 || args.size() > 100) {
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.arg.incorrect.range", (Object)this.getFunctionName(), (Object)1, (Object)100, (Object)args.size()) + " " + this.getI18n().getText("jira.jql.function.remote.link.by.global.id.incorrect.usage", this.getFunctionName()));
            return messageSet;
        }
        return messageSet;
    }

    @Nonnull
    public List<QueryLiteral> getValues(@Nonnull QueryCreationContext queryCreationContext, final @Nonnull FunctionOperand operand, @Nonnull TerminalClause terminalClause) {
        List remoteIssueLinks;
        Assertions.notNull((String)"operand", (Object)operand);
        if (!this.issueLinkManager.isLinkingEnabled()) {
            return ImmutableList.of();
        }
        List args = operand.getArgs();
        if (args.isEmpty()) {
            return ImmutableList.of();
        }
        try {
            remoteIssueLinks = this.remoteIssueLinkManager.findRemoteIssueLinksByGlobalIds((Collection)args);
        }
        catch (GetException e) {
            return ImmutableList.of();
        }
        Iterable issueIds = Iterables.transform((Iterable)remoteIssueLinks, (Function)new Function<RemoteIssueLink, Long>(){

            public Long apply(RemoteIssueLink remoteIssueLink) {
                return remoteIssueLink.getIssueId();
            }
        });
        ImmutableList issueIdsWithoutDup = ImmutableSet.copyOf((Iterable)issueIds).asList();
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)issueIdsWithoutDup, (Function)new Function<Long, QueryLiteral>(){

            public QueryLiteral apply(Long issueId) {
                return new QueryLiteral((Operand)operand, issueId);
            }
        }));
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    @Nonnull
    public JiraDataType getDataType() {
        return JiraDataTypes.ISSUE;
    }
}

