/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.ClusterLicenseCheck;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLicenseCheckImpl
implements ClusterLicenseCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterLicenseCheckImpl.class);

    @Override
    public LicenseCheck.Result evaluate() {
        JiraLicenseManager licenseManager = (JiraLicenseManager)ComponentAccessor.getComponent(JiraLicenseManager.class);
        if (!licenseManager.isLicenseSet()) {
            return FAIL_NO_LICENSES;
        }
        ImmutableList licenses = ImmutableList.copyOf((Iterable)licenseManager.getLicenses());
        ImmutableList nonDataCentreLicenses = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)licenses, license -> !license.isDataCenter()));
        if (!nonDataCentreLicenses.isEmpty()) {
            if (licenses.size() != nonDataCentreLicenses.size()) {
                LOG.warn("Clustering not permitted as there are non-DataCenter licenses present");
                return new LicenseCheck.Failure((List<LicenseDetails>)nonDataCentreLicenses, "Clustering not permitted as there are non-DataCenter licenses present");
            }
            return new LicenseCheck.Failure((List<LicenseDetails>)nonDataCentreLicenses, "Instance is not licensed for clustering");
        }
        return PASS;
    }
}

