/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.license.BuildVersionLicenseCheck;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseCheck;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseMaintenancePredicate;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public final class BuildVersionLicenseCheckImpl
implements BuildVersionLicenseCheck {
    private final JiraLicenseManager licenseManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final I18nHelper i18n;
    private final LicenseMaintenancePredicate isMaintenanceValid;
    private final DateTimeFormatter dateTimeFormatter;

    public BuildVersionLicenseCheckImpl(@Nonnull JiraLicenseManager licenseManager, @Nonnull BuildUtilsInfo buildUtilsInfo, @Nonnull I18nHelper i18n, @Nonnull DateTimeFormatter dateTimeFormatter, @Nonnull LicenseMaintenancePredicate isMaintenanceValid) {
        this.i18n = (I18nHelper)Assertions.notNull((String)"i18n", (Object)i18n);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.dateTimeFormatter = ((DateTimeFormatter)Assertions.notNull((String)"dateTimeFormatter", (Object)dateTimeFormatter)).withSystemZone();
        this.isMaintenanceValid = (LicenseMaintenancePredicate)Assertions.notNull((String)"isMaintenanceValid", (Object)isMaintenanceValid);
        this.licenseManager = (JiraLicenseManager)Assertions.notNull((String)"licenseManager", (Object)licenseManager);
    }

    @Override
    public LicenseCheck.Result evaluate() {
        return this.evaluate(true);
    }

    @Override
    public LicenseCheck.Result evaluateWithoutGracePeriod() {
        return this.evaluate(false);
    }

    private LicenseCheck.Result evaluate(boolean considerGracePeriodStatus) {
        Iterable licenses = this.licenseManager.getLicenses();
        if (Iterables.isEmpty((Iterable)licenses)) {
            return FAIL_NO_LICENSES;
        }
        Iterable ancientLicenses = Iterables.filter((Iterable)licenses, license -> license.getLicenseVersion() == 1);
        if (!Iterables.isEmpty((Iterable)ancientLicenses)) {
            return new LicenseCheck.Failure((List<LicenseDetails>)ImmutableList.copyOf((Iterable)ancientLicenses), this.i18n.getText("setup.error.invalidlicensekey.v1.license.version"));
        }
        if (considerGracePeriodStatus && this.licenseManager.hasLicenseTooOldForBuildConfirmationBeenDone()) {
            return PASS;
        }
        if (this.allLicensesAreELAs(licenses)) {
            return PASS;
        }
        List<LicenseDetails> licensesPastMaintenance = this.filterLicensesPastMaintenance(licenses);
        if (licensesPastMaintenance.isEmpty()) {
            return PASS;
        }
        return new LicenseCheck.Failure(licensesPastMaintenance, this.getMaintenanceDateFailureMessage(licensesPastMaintenance));
    }

    private List<LicenseDetails> filterLicensesPastMaintenance(Iterable<LicenseDetails> licenses) {
        return (List)StreamSupport.stream(licenses.spliterator(), false).filter(this.isMaintenanceValid.negate()).collect(CollectorsUtil.toImmutableList());
    }

    private boolean allLicensesAreELAs(Iterable<LicenseDetails> licenses) {
        for (LicenseDetails license : licenses) {
            if (license.isEnterpriseLicenseAgreement()) continue;
            return false;
        }
        return true;
    }

    private String getMaintenanceDateFailureMessage(List<LicenseDetails> licensesPastMaintenance) {
        String expiredAppDescription = licensesPastMaintenance.stream().map(LicenseDetails::getApplicationDescription).collect(Collectors.joining(", "));
        Date expiryDateOfInstance = licensesPastMaintenance.stream().map(LicenseDetails::getMaintenanceExpiryDate).min(Date::compareTo).get();
        return this.i18n.getText("admin.license.build.update.not.possible", this.buildUtilsInfo.getVersion(), this.dateTimeFormatter.format(expiryDateOfInstance), expiredAppDescription);
    }
}

