/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.thumbnail;

import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.thumbnail.BrokenThumbnail;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

class AtlassianCoreThumbnail
implements ThumbnailedImage {
    private static final String BROKEN_THUMBNAIL_URL = "/images/broken_thumbnail.png";
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContext velocityRequestContext;
    private final Thumbnail thumbnail;

    public AtlassianCoreThumbnail(ApplicationProperties applicationProperties, VelocityRequestContext velocityRequestContext, Thumbnail thumbnail) {
        this.applicationProperties = applicationProperties;
        this.velocityRequestContext = velocityRequestContext;
        this.thumbnail = thumbnail;
    }

    public String getFilename() {
        return this.thumbnail.getFilename();
    }

    public int getHeight() {
        return this.thumbnail.getHeight();
    }

    public int getWidth() {
        return this.thumbnail.getWidth();
    }

    public long getAttachmentId() {
        return this.thumbnail.getAttachmentId();
    }

    public String getMimeType() {
        return this.thumbnail.getMimeType().name();
    }

    @HtmlSafe
    public String getImageURL() {
        if (this.thumbnail == null) {
            return null;
        }
        if (this.thumbnail instanceof BrokenThumbnail) {
            return this.velocityRequestContext.getCanonicalBaseUrl() + BROKEN_THUMBNAIL_URL;
        }
        return String.format("%s/secure/thumbnail/%s/%s", this.velocityRequestContext.getCanonicalBaseUrl(), this.thumbnail.getAttachmentId(), this.urlEncode(this.thumbnail.getFilename()));
    }

    private String urlEncode(String encode) {
        try {
            return URLEncoder.encode(encode, this.applicationProperties.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(encode);
        }
    }
}

